/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.client;

import com.stal111.forbidden_arcanus.common.block.entity.clibano.residue.ResidueType;
import com.stal111.forbidden_arcanus.common.essence.EssenceHelper;
import com.stal111.forbidden_arcanus.common.inventory.clibano.ClibanoMenu;
import com.stal111.forbidden_arcanus.common.network.clientbound.AdvancedBlockEventPayload;
import com.stal111.forbidden_arcanus.common.network.clientbound.SetClibanoResiduesPayload;
import com.stal111.forbidden_arcanus.common.network.clientbound.SpawnParticlePayload;
import com.stal111.forbidden_arcanus.common.network.clientbound.TransformPedestalPayload;
import com.stal111.forbidden_arcanus.common.network.clientbound.UpdateEssencePayload;
import com.stal111.forbidden_arcanus.core.init.ModParticles;
import com.stal111.forbidden_arcanus.core.init.ModSounds;
import com.stal111.forbidden_arcanus.core.mixin.LevelRendererAccessor;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public final class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();
    private final Minecraft minecraft = Minecraft.getInstance();

    private ClientPayloadHandler() {
    }

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handle(SetClibanoResiduesPayload payload, IPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu;
        Player player = context.player();
        if (player.hasContainerOpen() && (abstractContainerMenu = player.containerMenu) instanceof ClibanoMenu) {
            ClibanoMenu menu = (ClibanoMenu)abstractContainerMenu;
            menu.setResidueData((Map<Holder<ResidueType>, Integer>)payload.residueAmounts().getResidueTypeAmountMap());
        }
    }

    public void handle(TransformPedestalPayload payload, IPayloadContext context) {
        ParticleUtils.spawnParticlesOnBlockFaces((Level)this.minecraft.level, (BlockPos)payload.pos(), (ParticleOptions)((ParticleOptions)ModParticles.MAGNETIC_GLOW.get()), (IntProvider)UniformInt.of((int)3, (int)5));
        this.minecraft.level.playLocalSound(payload.pos(), (SoundEvent)ModSounds.FERROGNETIC_MIXTURE_APPLY.get(), SoundSource.PLAYERS, 0.75f, 0.9f + this.minecraft.level.getRandom().nextFloat() * 0.1f, false);
    }

    public void handle(SpawnParticlePayload payload, IPayloadContext context) {
        RandomSource random = this.minecraft.level.getRandom();
        LevelRenderer levelRenderer = this.minecraft.levelRenderer;
        double x = payload.x();
        double y = payload.y();
        double z = payload.z();
        for (int l = 0; l < 8; ++l) {
            this.minecraft.level.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)Items.SPLASH_POTION)), x, y, z, random.nextGaussian() * 0.15, random.nextDouble() * 0.2, random.nextGaussian() * 0.15);
        }
        ParticleOptions particleoptions = (ParticleOptions)ModParticles.AUREAL_MOTE.get();
        for (int j3 = 0; j3 < 100; ++j3) {
            double xPos = random.nextDouble() * 4.0;
            double zPos = random.nextDouble() * Math.PI * 2.0;
            double xSpeed = Math.cos(zPos) * xPos;
            double ySpeed = ((double)random.nextFloat() - 0.4) * 0.125;
            double zSpeed = Math.sin(zPos) * xPos;
            Particle particle = ((LevelRendererAccessor)levelRenderer).callAddParticleInternal(particleoptions, particleoptions.getType().getOverrideLimiter(), x + xSpeed * 0.1, y + 0.3, z + zSpeed * 0.1, xSpeed, ySpeed, zSpeed);
            particle.setLifetime(25 + random.nextInt(10));
        }
        this.minecraft.level.playLocalSound(x, y, z, SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, random.nextFloat() * 0.1f + 0.9f, false);
    }

    public void handle(UpdateEssencePayload payload, IPayloadContext context) {
        EssenceHelper.getEssenceProvider((LivingEntity)context.player()).ifPresent(provider -> provider.setStorage(payload.storage()));
    }

    public void handle(AdvancedBlockEventPayload payload, IPayloadContext context) {
        this.minecraft.level.blockEvent(payload.pos(), payload.block(), payload.b1(), payload.b2());
    }
}

