/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.loading.FMLEnvironment;
import net.p3pp3rf1y.sophisticatedcore.client.gui.utils.TranslationHelper;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageItemClient;

public class WoodStorageBlockItem
extends StorageBlockItem {
    public static final StreamCodec<FriendlyByteBuf, WoodType> WOOD_TYPE_STREAM_CODEC = StreamCodec.of((buf, wt) -> buf.writeUtf(wt.name()), buf -> {
        WoodType woodType = (WoodType)WoodType.TYPES.get(buf.readUtf());
        return woodType == null ? WoodType.OAK : woodType;
    });

    public WoodStorageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void setPacked(ItemStack storageStack, boolean packed) {
        storageStack.set(ModDataComponents.PACKED, (Object)packed);
    }

    public static boolean isPacked(ItemStack storageStack) {
        return (Boolean)storageStack.getOrDefault(ModDataComponents.PACKED, (Object)false);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (WoodStorageBlockItem.isPacked(stack)) {
            HolderLookup.Provider registries;
            if (flagIn == TooltipFlag.ADVANCED && (registries = context.registries()) != null) {
                StackStorageWrapper.fromStack(registries, stack).getContentsUuid().ifPresent(uuid -> tooltip.add((Component)Component.literal((String)("UUID: " + String.valueOf(uuid))).withStyle(ChatFormatting.DARK_GRAY)));
            }
            if (!Screen.hasShiftDown()) {
                tooltip.add((Component)Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".press_for_contents"), (Object[])new Object[]{Component.translatable((String)(TranslationHelper.INSTANCE.translItemTooltip("storage") + ".shift")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (!WoodStorageBlockItem.isPacked(stack)) {
            return Optional.empty();
        }
        if (FMLEnvironment.dist.isClient()) {
            return Optional.ofNullable(StorageItemClient.getTooltipImage(stack));
        }
        return Optional.empty();
    }

    @Override
    public void setMainColor(ItemStack storageStack, int mainColor) {
        if (StorageBlockItem.getAccentColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setMainColor(storageStack, mainColor);
    }

    @Override
    public void setAccentColor(ItemStack storageStack, int accentColor) {
        if (StorageBlockItem.getMainColorFromStack(storageStack).isPresent()) {
            this.removeWoodType(storageStack);
        }
        super.setAccentColor(storageStack, accentColor);
    }

    private void removeWoodType(ItemStack storageStack) {
        storageStack.remove(ModDataComponents.WOOD_TYPE);
    }

    public static Optional<WoodType> getWoodType(ItemStack storageStack) {
        return Optional.ofNullable((WoodType)storageStack.get(ModDataComponents.WOOD_TYPE));
    }

    public static ItemStack setWoodType(ItemStack storageStack, WoodType woodType) {
        storageStack.set(ModDataComponents.WOOD_TYPE, (Object)woodType);
        return storageStack;
    }

    public Component getName(ItemStack stack) {
        return WoodStorageBlockItem.getDisplayName(this.getDescriptionId(), WoodStorageBlockItem.getWoodType(stack).orElse(null));
    }

    public static Component getDisplayName(String descriptionId, @Nullable WoodType woodType) {
        if (woodType == null) {
            return Component.translatable((String)descriptionId, (Object[])new Object[]{"", ""});
        }
        return Component.translatable((String)descriptionId, (Object[])new Object[]{Component.translatable((String)("wood_name.sophisticatedstorage." + woodType.name().toLowerCase(Locale.ROOT))), " "});
    }

    public static void setNumberOfInventorySlots(ItemStack storageStack, int numberOfInventorySlots) {
        storageStack.set(ModCoreDataComponents.NUMBER_OF_INVENTORY_SLOTS, (Object)numberOfInventorySlots);
    }

    public static void setNumberOfUpgradeSlots(ItemStack storageStack, int numberOfUpgradeSlots) {
        storageStack.set(ModCoreDataComponents.NUMBER_OF_UPGRADE_SLOTS, (Object)numberOfUpgradeSlots);
    }
}

