/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class StorageTierUpgradeItem
extends ItemBase {
    private final TierUpgrade tier;
    private final boolean hasTooltip;

    public StorageTierUpgradeItem(TierUpgrade tier) {
        this(tier, false);
    }

    public StorageTierUpgradeItem(TierUpgrade tier, boolean hasTooltip) {
        super(new Item.Properties());
        this.tier = tier;
        this.hasTooltip = hasTooltip;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (this.hasTooltip) {
            tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.getItem().getDescriptionId() + ".tooltip", null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
        }
        super.appendHoverText(stack, context, tooltipComponents, isAdvanced);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level level = context.getLevel();
        if (level.isClientSide) {
            return InteractionResult.PASS;
        }
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        return this.tryUpgradeStorage(stack, level, pos, state, player);
    }

    public InteractionResult tryUpgradeStorage(ItemStack stack, Level level, BlockPos pos, BlockState state, @Nullable Player player) {
        return this.tier.getBlockUpgradeDefinition(state.getBlock()).map(def -> WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, def.blockEntityClass()).map(be -> this.tryUpgradeStorage(stack, pos, level, state, (TierUpgradeDefinition)def, (BlockEntity)be, player)).orElse(InteractionResult.PASS)).orElse(InteractionResult.PASS);
    }

    private <B extends BlockEntity> InteractionResult tryUpgradeStorage(ItemStack stack, BlockPos pos, Level level, BlockState state, TierUpgradeDefinition<B> def, BlockEntity blockEntity, @Nullable Player player) {
        BlockEntity be = (BlockEntity)def.blockEntityClass().cast(blockEntity);
        if (def.isUpgradingBlocked().test(be)) {
            return InteractionResult.PASS;
        }
        if (player == null) {
            return InteractionResult.PASS;
        }
        int countRequired = def.getCountRequired(state);
        if (countRequired > stack.getCount()) {
            player.displayClientMessage((Component)Component.translatable((String)StorageTranslationHelper.INSTANCE.translGui("status.too_low_tier_upgrade_count"), (Object[])new Object[]{countRequired, stack.getHoverName()}), true);
            return InteractionResult.FAIL;
        }
        if (!def.upgradeStorage(player, pos, level, state, be)) {
            return InteractionResult.PASS;
        }
        if (!player.getAbilities().instabuild) {
            stack.shrink(countRequired);
        }
        return InteractionResult.SUCCESS;
    }

    private static Map<Block, TierUpgradeDefinition<?>> getVanillaShulkerBoxTierUpgradeDefinitions(net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock toShulkerBox) {
        return new ImmutableMap.Builder().put((Object)Blocks.SHULKER_BOX, new VanillaTierUpgradeDefinition<ShulkerBoxBlockEntity>(ShulkerBoxBlockEntity.class, shulkerBoxBlockEntity -> shulkerBoxBlockEntity.openCount > 0, (StorageBlockBase)toShulkerBox, null, new Property[]{ShulkerBoxBlock.FACING})).put((Object)Blocks.WHITE_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.WHITE, toShulkerBox)).put((Object)Blocks.ORANGE_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.ORANGE, toShulkerBox)).put((Object)Blocks.MAGENTA_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.MAGENTA, toShulkerBox)).put((Object)Blocks.LIGHT_BLUE_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_BLUE, toShulkerBox)).put((Object)Blocks.YELLOW_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.YELLOW, toShulkerBox)).put((Object)Blocks.LIME_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIME, toShulkerBox)).put((Object)Blocks.PINK_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PINK, toShulkerBox)).put((Object)Blocks.GRAY_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GRAY, toShulkerBox)).put((Object)Blocks.LIGHT_GRAY_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.LIGHT_GRAY, toShulkerBox)).put((Object)Blocks.CYAN_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.CYAN, toShulkerBox)).put((Object)Blocks.PURPLE_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.PURPLE, toShulkerBox)).put((Object)Blocks.BLUE_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLUE, toShulkerBox)).put((Object)Blocks.BROWN_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BROWN, toShulkerBox)).put((Object)Blocks.GREEN_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.GREEN, toShulkerBox)).put((Object)Blocks.RED_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.RED, toShulkerBox)).put((Object)Blocks.BLACK_SHULKER_BOX, (Object)new VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor.BLACK, toShulkerBox)).build();
    }

    public static enum TierUpgrade {
        BASIC(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.BARREL, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.BARREL.get(), WoodType.SPRUCE, new Property[]{BlockStateProperties.FACING})).put((Object)Blocks.CHEST, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, chestBlockEntity -> chestBlockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.CHEST.get(), WoodType.OAK, new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.SHULKER_BOX.get())).build())),
        BASIC_TO_COPPER(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.BARREL, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.COPPER_BARREL.get(), WoodType.SPRUCE, new Property[]{BlockStateProperties.FACING})).put((Object)Blocks.CHEST, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.COPPER_CHEST.get(), WoodType.OAK, new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.COPPER_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.COPPER_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.COPPER_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.COPPER_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_COPPER_BARREL_4.get())).build())),
        BASIC_TO_IRON(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.BARREL, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.IRON_BARREL.get(), WoodType.SPRUCE, new Property[]{BlockStateProperties.FACING})).put((Object)Blocks.CHEST, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.IRON_CHEST.get(), WoodType.OAK, new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.IRON_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_4.get())).build())),
        BASIC_TO_GOLD(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.BARREL, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.GOLD_BARREL.get(), WoodType.SPRUCE, new Property[]{BlockStateProperties.FACING})).put((Object)Blocks.CHEST, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.GOLD_CHEST.get(), WoodType.OAK, new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.GOLD_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4.get())).build())),
        BASIC_TO_DIAMOND(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.BARREL, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.DIAMOND_BARREL.get(), WoodType.SPRUCE, new Property[]{BlockStateProperties.FACING})).put((Object)Blocks.CHEST, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.DIAMOND_CHEST.get(), WoodType.OAK, new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.DIAMOND_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4.get())).build())),
        BASIC_TO_NETHERITE(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)Blocks.BARREL, new VanillaTierUpgradeDefinition<BarrelBlockEntity>(BarrelBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.NETHERITE_BARREL.get(), WoodType.SPRUCE, new Property[]{BlockStateProperties.FACING})).put((Object)Blocks.CHEST, new VanillaTierUpgradeDefinition<ChestBlockEntity>(ChestBlockEntity.class, blockEntity -> blockEntity.openersCounter.getOpenerCount() > 0, (StorageBlockBase)ModBlocks.NETHERITE_CHEST.get(), WoodType.OAK, new Property[]{BlockStateProperties.HORIZONTAL_FACING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).putAll(StorageTierUpgradeItem.getVanillaShulkerBoxTierUpgradeDefinitions(ModBlocks.NETHERITE_SHULKER_BOX.get())).put((Object)((Block)ModBlocks.BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4.get())).build())),
        COPPER_TO_IRON(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.IRON_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_IRON_BARREL_4.get())).build())),
        COPPER_TO_GOLD(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4.get())).build())),
        COPPER_TO_DIAMOND(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4.get())).build())),
        COPPER_TO_NETHERITE(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.COPPER_BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.COPPER_CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.COPPER_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_COPPER_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4.get())).build())),
        IRON_TO_GOLD(Map.of((Block)ModBlocks.IRON_BARREL.get(), new StorageTierUpgradeDefinition(ModBlocks.GOLD_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.IRON_CHEST.get(), new StorageTierUpgradeDefinition(ModBlocks.GOLD_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE}), (Block)ModBlocks.IRON_SHULKER_BOX.get(), new StorageTierUpgradeDefinition(ModBlocks.GOLD_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING}), (Block)ModBlocks.LIMITED_IRON_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_1.get()), (Block)ModBlocks.LIMITED_IRON_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_2.get()), (Block)ModBlocks.LIMITED_IRON_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_3.get()), (Block)ModBlocks.LIMITED_IRON_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_GOLD_BARREL_4.get()))),
        IRON_TO_DIAMOND(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.IRON_BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.IRON_CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.IRON_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4.get())).build())),
        IRON_TO_NETHERITE(new HashMap<Block, TierUpgradeDefinition<?>>((Map<Block, TierUpgradeDefinition<?>>)new ImmutableMap.Builder().put((Object)((Block)ModBlocks.IRON_BARREL.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP})).put((Object)((Block)ModBlocks.IRON_CHEST.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE})).put((Object)((Block)ModBlocks.IRON_SHULKER_BOX.get()), (Object)new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING})).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_1.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_2.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_3.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3.get())).put((Object)((Block)ModBlocks.LIMITED_IRON_BARREL_4.get()), (Object)new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4.get())).build())),
        GOLD_TO_DIAMOND(Map.of((Block)ModBlocks.GOLD_BARREL.get(), new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.GOLD_CHEST.get(), new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE}), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), new StorageTierUpgradeDefinition(ModBlocks.DIAMOND_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING}), (Block)ModBlocks.LIMITED_GOLD_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_1.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_2.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_3.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_DIAMOND_BARREL_4.get()))),
        GOLD_TO_NETHERITE(Map.of((Block)ModBlocks.GOLD_BARREL.get(), new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.GOLD_CHEST.get(), new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE}), (Block)ModBlocks.GOLD_SHULKER_BOX.get(), new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING}), (Block)ModBlocks.LIMITED_GOLD_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3.get()), (Block)ModBlocks.LIMITED_GOLD_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4.get()))),
        DIAMOND_TO_NETHERITE(Map.of((Block)ModBlocks.DIAMOND_BARREL.get(), new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_BARREL.get(), new Property[]{BlockStateProperties.FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP}), (Block)ModBlocks.DIAMOND_CHEST.get(), new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_CHEST.get(), new Property[]{BlockStateProperties.HORIZONTAL_FACING, StorageBlockBase.TICKING, BlockStateProperties.WATERLOGGED, BlockStateProperties.CHEST_TYPE}), (Block)ModBlocks.DIAMOND_SHULKER_BOX.get(), new StorageTierUpgradeDefinition(ModBlocks.NETHERITE_SHULKER_BOX.get(), new Property[]{BlockStateProperties.FACING}), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_1.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_1.get()), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_2.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_2.get()), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_3.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_3.get()), (Block)ModBlocks.LIMITED_DIAMOND_BARREL_4.get(), new LimitedBarrelTierUpgradeDefinition(ModBlocks.LIMITED_NETHERITE_BARREL_4.get())));

        private final Map<Block, TierUpgradeDefinition<?>> blockUpgradeDefinitions;

        private TierUpgrade(Map<Block, TierUpgradeDefinition<?>> blockUpgradeDefinitions) {
            this.blockUpgradeDefinitions = blockUpgradeDefinitions;
        }

        public void addTierUpgradeDefinition(Block block, VanillaTierUpgradeDefinition<?> tierUpgradeDefinition) {
            this.blockUpgradeDefinitions.put(block, tierUpgradeDefinition);
        }

        private Optional<TierUpgradeDefinition<?>> getBlockUpgradeDefinition(Block block) {
            return Optional.ofNullable(this.blockUpgradeDefinitions.get(block));
        }
    }

    private static abstract class TierUpgradeDefinition<B extends BlockEntity> {
        private final List<Property<?>> propertiesToCopy;
        private final Class<B> blockEntityClass;
        private final Predicate<B> isUpgradingBlocked;
        private final StorageBlockBase newBlock;

        private TierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, Property<?> ... propertiesToCopy) {
            this.propertiesToCopy = Arrays.stream(propertiesToCopy).toList();
            this.blockEntityClass = blockEntityClass;
            this.isUpgradingBlocked = isUpgradingBlocked;
            this.newBlock = newBlock;
        }

        public List<Property<?>> getPropertiesToCopy() {
            return this.propertiesToCopy;
        }

        public Class<B> blockEntityClass() {
            return this.blockEntityClass;
        }

        public Predicate<B> isUpgradingBlocked() {
            return this.isUpgradingBlocked;
        }

        public StorageBlockBase newBlock() {
            return this.newBlock;
        }

        abstract boolean upgradeStorage(@Nullable Player var1, BlockPos var2, Level var3, BlockState var4, B var5);

        protected BlockState getBlockState(BlockState state) {
            BlockState newBlockState = this.newBlock().defaultBlockState();
            for (Property<?> property : this.getPropertiesToCopy()) {
                newBlockState = this.setProperty(newBlockState, state, property);
            }
            return newBlockState;
        }

        private <T extends Comparable<T>> BlockState setProperty(BlockState newBlockState, BlockState state, Property<T> property) {
            return (BlockState)newBlockState.setValue(property, state.getValue(property));
        }

        public int getCountRequired(BlockState state) {
            return 1;
        }
    }

    public static class VanillaTierUpgradeDefinition<B extends RandomizableContainerBlockEntity>
    extends TierUpgradeDefinition<B> {
        @Nullable
        private final WoodType woodType;
        private final int color;

        public VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, Property<?> ... propertiesToCopy) {
            this(blockEntityClass, isUpgradingBlocked, newBlock, woodType, -1, propertiesToCopy);
        }

        private VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, DyeColor color, Property<?> ... propertiesToCopy) {
            this(blockEntityClass, isUpgradingBlocked, newBlock, woodType, color.getTextureDiffuseColor(), propertiesToCopy);
        }

        private VanillaTierUpgradeDefinition(Class<B> blockEntityClass, Predicate<B> isUpgradingBlocked, StorageBlockBase newBlock, @Nullable WoodType woodType, int color, Property<?> ... propertiesToCopy) {
            super(blockEntityClass, isUpgradingBlocked, newBlock, propertiesToCopy);
            this.woodType = woodType;
            this.color = color;
        }

        @Override
        public int getCountRequired(BlockState state) {
            if (state.getBlock() instanceof ChestBlock && state.getValue((Property)BlockStateProperties.CHEST_TYPE) != ChestType.SINGLE) {
                return 2;
            }
            return super.getCountRequired(state);
        }

        @Nullable
        public WoodType woodType() {
            return this.woodType;
        }

        @Override
        boolean upgradeStorage(@Nullable Player player, BlockPos pos, Level level, BlockState state, B be) {
            BlockState otherState;
            if (player == null || !be.canOpen(player)) {
                return false;
            }
            if (state.getBlock() instanceof ChestBlock && state.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
                otherState = level.getBlockState(pos.relative(ChestBlock.getConnectedDirection((BlockState)state)));
                if (otherState.getBlock() != state.getBlock()) {
                    otherState = null;
                }
            } else {
                otherState = null;
            }
            StorageBlockEntity upgradedBe = this.upgradeStorage(pos, level, state, be);
            upgradedBe.tryToAddToController();
            if (otherState != null && otherState.getValue((Property)ChestBlock.TYPE) != ChestType.SINGLE && state.getBlock() instanceof ChestBlock) {
                BlockPos otherPos = pos.relative(ChestBlock.getConnectedDirection((BlockState)state));
                RandomizableContainerBlockEntity otherBE = WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)otherPos, (Class)this.blockEntityClass()).orElse(null);
                if (otherBE == null) {
                    return true;
                }
                this.upgradeStorage(otherPos, level, otherState, otherBE);
                level.getBlockEntity(otherPos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(otherChestBE -> {
                    level.getBlockEntity(pos, ModBlocks.CHEST_BLOCK_ENTITY_TYPE.get()).ifPresent(mainBE -> {
                        if (state.getValue((Property)ChestBlock.TYPE) == ChestType.LEFT) {
                            mainBE.joinWithChest((net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity)otherChestBE);
                        } else {
                            otherChestBE.joinWithChest((net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity)mainBE);
                        }
                    });
                    WorldHelper.notifyBlockUpdate((BlockEntity)otherChestBE);
                });
                level.getBlockState(otherPos).updateNeighbourShapes((LevelAccessor)level, otherPos, 3);
            }
            return true;
        }

        private StorageBlockEntity upgradeStorage(BlockPos pos, Level level, BlockState state, B be) {
            Component customName = be.getCustomName();
            NonNullList items = NonNullList.create();
            for (int slot = 0; slot < be.getContainerSize(); ++slot) {
                items.add(slot, (Object)be.getItem(slot));
            }
            BlockState newBlockState = this.getBlockState(state);
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            this.setStorageItemsNameAndWoodType(newBlockEntity, customName, (NonNullList<ItemStack>)items, this.woodType());
            newBlockEntity.setUpdateBlockRender();
            this.replaceBlockAndBlockEntity(newBlockState, newBlockEntity, pos, level);
            WorldHelper.notifyBlockUpdate((BlockEntity)newBlockEntity);
            return newBlockEntity;
        }

        private void replaceBlockAndBlockEntity(BlockState newBlockState, BlockEntity newBlockEntity, BlockPos pos, Level level) {
            level.removeBlockEntity(pos);
            level.removeBlock(pos, false);
            level.setBlock(pos, newBlockState, 3);
            level.setBlockEntity(newBlockEntity);
        }

        private void setStorageItemsNameAndWoodType(StorageBlockEntity newBe, @Nullable Component customName, NonNullList<ItemStack> items, @Nullable WoodType woodType) {
            StorageWrapper storageWrapper;
            InventoryHandler inventoryHandler;
            if (customName != null) {
                newBe.setCustomName(customName);
            }
            if ((inventoryHandler = (storageWrapper = newBe.getStorageWrapper()).getInventoryHandler()).getSlots() < items.size()) {
                inventoryHandler.setSize(items.size());
            }
            for (int slot = 0; slot < items.size(); ++slot) {
                inventoryHandler.setStackInSlot(slot, (ItemStack)items.get(slot));
            }
            if (woodType != null && newBe instanceof WoodStorageBlockEntity) {
                WoodStorageBlockEntity wbe = (WoodStorageBlockEntity)newBe;
                wbe.setWoodType(woodType);
            }
            if (this.color != -1) {
                storageWrapper.setMainColor(this.color);
                storageWrapper.setAccentColor(this.color);
            }
        }
    }

    private static class VanillaTintedShulkerBoxTierUpgradeDefinition
    extends VanillaTierUpgradeDefinition<ShulkerBoxBlockEntity> {
        private VanillaTintedShulkerBoxTierUpgradeDefinition(DyeColor color, net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlock newBlock) {
            super(ShulkerBoxBlockEntity.class, (B shulkerBoxBlockEntity) -> shulkerBoxBlockEntity.openCount > 0, (StorageBlockBase)newBlock, null, color, new Property[]{ShulkerBoxBlock.FACING, StorageBlockBase.TICKING});
        }
    }

    private static class LimitedBarrelTierUpgradeDefinition
    extends StorageTierUpgradeDefinition {
        private LimitedBarrelTierUpgradeDefinition(StorageBlockBase newBlock) {
            super(newBlock, new Property[]{LimitedBarrelBlock.HORIZONTAL_FACING, LimitedBarrelBlock.VERTICAL_FACING, StorageBlockBase.TICKING, BarrelBlock.FLAT_TOP});
        }
    }

    private static class StorageTierUpgradeDefinition
    extends TierUpgradeDefinition<StorageBlockEntity> {
        private StorageTierUpgradeDefinition(StorageBlockBase newBlock, Property<?> ... propertiesToCopy) {
            super(StorageBlockEntity.class, (B storageBlockEntity) -> {
                WoodStorageBlockEntity wbe;
                return storageBlockEntity.isOpen() || storageBlockEntity instanceof WoodStorageBlockEntity && (wbe = (WoodStorageBlockEntity)storageBlockEntity).isPacked();
            }, newBlock, propertiesToCopy);
        }

        @Override
        boolean upgradeStorage(@Nullable Player player, BlockPos pos, Level level, BlockState state, StorageBlockEntity blockEntity) {
            BlockState newBlockState;
            Block block;
            if (blockEntity instanceof net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity) {
                net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity chestBlockEntity = (net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity)blockEntity;
                if (state.getValue(net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock.TYPE) != ChestType.SINGLE) {
                    return this.upgradeDoubleChest(pos, level, state, chestBlockEntity);
                }
            }
            if (!((block = (newBlockState = this.getBlockState(state)).getBlock()) instanceof StorageBlockBase)) {
                return false;
            }
            StorageBlockBase newStorageBlock = (StorageBlockBase)block;
            this.upgradeStorageBlock(pos, level, blockEntity, newBlockState, newStorageBlock.getNumberOfInventorySlots(), newStorageBlock.getNumberOfUpgradeSlots()).setBeingUpgraded(false);
            return true;
        }

        private StorageBlockEntity upgradeStorageBlock(BlockPos pos, Level level, StorageBlockEntity blockEntity, BlockState newBlockState, int newInventorySize, int newUpgradeSize) {
            CompoundTag beTag = new CompoundTag();
            blockEntity.saveAdditional(beTag, (HolderLookup.Provider)level.registryAccess());
            StorageBlockEntity newBlockEntity = this.newBlock().newBlockEntity(pos, newBlockState);
            newBlockEntity.setBeingUpgraded(true);
            newBlockEntity.loadAdditional(beTag, (HolderLookup.Provider)level.registryAccess());
            blockEntity.setBeingUpgraded(true);
            level.removeBlockEntity(pos);
            level.removeBlock(pos, false);
            level.setBlock(pos, newBlockState, 3);
            level.setBlockEntity((BlockEntity)newBlockEntity);
            newBlockEntity.changeStorageSize(newInventorySize - newBlockEntity.getStorageWrapper().getInventoryHandler().getSlots(), newUpgradeSize - newBlockEntity.getStorageWrapper().getUpgradeHandler().getSlots());
            WorldHelper.notifyBlockUpdate((BlockEntity)newBlockEntity);
            return newBlockEntity;
        }

        private boolean upgradeDoubleChest(BlockPos pos, Level level, BlockState state, net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity chestBlockEntity) {
            Block block;
            BlockPos otherPos = pos.relative(net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock.getConnectedDirection(state));
            net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity otherBlockEntity = WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)otherPos, net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity.class).orElse(null);
            BlockState otherBlockState = this.getBlockState(level.getBlockState(otherPos));
            if (otherBlockEntity == null || !((block = otherBlockState.getBlock()) instanceof StorageBlockBase)) {
                return false;
            }
            StorageBlockBase storageBlock = (StorageBlockBase)block;
            chestBlockEntity.setBeingUpgraded(true);
            otherBlockEntity.setBeingUpgraded(true);
            if (chestBlockEntity.isMainChest()) {
                StorageBlockEntity newMainBE = this.upgradeStorageBlock(pos, level, chestBlockEntity, this.getBlockState(state), storageBlock.getNumberOfInventorySlots() * 2, storageBlock.getNumberOfUpgradeSlots());
                this.upgradeStorageBlock(otherPos, level, otherBlockEntity, otherBlockState, storageBlock.getNumberOfInventorySlots(), storageBlock.getNumberOfUpgradeSlots()).setBeingUpgraded(false);
                newMainBE.setBeingUpgraded(false);
            } else {
                StorageBlockEntity newOtherBE = this.upgradeStorageBlock(pos, level, chestBlockEntity, this.getBlockState(state), storageBlock.getNumberOfInventorySlots(), storageBlock.getNumberOfUpgradeSlots());
                this.upgradeStorageBlock(otherPos, level, otherBlockEntity, otherBlockState, storageBlock.getNumberOfInventorySlots() * 2, storageBlock.getNumberOfUpgradeSlots()).setBeingUpgraded(false);
                newOtherBE.setBeingUpgraded(false);
            }
            otherBlockState.updateNeighbourShapes((LevelAccessor)level, otherPos, 3);
            return true;
        }

        @Override
        public int getCountRequired(BlockState state) {
            if (state.getBlock() instanceof net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock && state.getValue(net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock.TYPE) != ChestType.SINGLE) {
                return 2;
            }
            return super.getCountRequired(state);
        }
    }
}

