/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedcore.init.ModCoreDataComponents;
import net.p3pp3rf1y.sophisticatedcore.util.BlockItemBase;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;

public class StorageBlockItem
extends BlockItemBase
implements ITintableBlockItem {
    public StorageBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static Optional<CompoundTag> getEntityWrapperTagFromStack(ItemStack barrelStack) {
        CustomData customData = (CustomData)barrelStack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData == null) {
            return Optional.empty();
        }
        return Optional.of(customData.copyTag().getCompound("storageWrapper"));
    }

    public static Optional<Integer> getMainColorFromStack(ItemStack storageStack) {
        return StorageBlockItem.getEntityWrapperTagFromStack(storageStack).flatMap(tag -> tag.contains("mainColor") ? Optional.of(tag.getInt("mainColor")) : Optional.empty()).or(() -> Optional.ofNullable((Integer)storageStack.get(ModCoreDataComponents.MAIN_COLOR)));
    }

    public static Optional<Integer> getAccentColorFromStack(ItemStack storageStack) {
        return StorageBlockItem.getEntityWrapperTagFromStack(storageStack).flatMap(tag -> tag.contains("accentColor") ? Optional.of(tag.getInt("accentColor")) : Optional.empty()).or(() -> Optional.ofNullable((Integer)storageStack.get(ModCoreDataComponents.ACCENT_COLOR)));
    }

    @Override
    public void setMainColor(ItemStack storageStack, int mainColor) {
        storageStack.set(ModCoreDataComponents.MAIN_COLOR, (Object)mainColor);
    }

    @Override
    public Optional<Integer> getMainColor(ItemStack storageStack) {
        return StorageBlockItem.getMainColorFromStack(storageStack);
    }

    @Override
    public void setAccentColor(ItemStack storageStack, int accentColor) {
        storageStack.set(ModCoreDataComponents.ACCENT_COLOR, (Object)accentColor);
    }

    @Override
    public void removeMainColor(ItemStack stack) {
        stack.remove(ModCoreDataComponents.MAIN_COLOR);
    }

    @Override
    public void removeAccentColor(ItemStack stack) {
        stack.remove(ModCoreDataComponents.ACCENT_COLOR);
    }

    @Override
    public Optional<Integer> getAccentColor(ItemStack stack) {
        return StorageBlockItem.getAccentColorFromStack(stack);
    }

    public static boolean showsTier(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.SHOWS_TIER, (Object)true);
    }

    public static void setShowsTier(ItemStack stack, boolean showsTier) {
        if (showsTier) {
            stack.remove(ModDataComponents.SHOWS_TIER);
        } else {
            stack.set(ModDataComponents.SHOWS_TIER, (Object)false);
        }
    }
}

