/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Keyable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class BarrelBlockItem
extends WoodStorageBlockItem {
    public static final Codec<Map<BarrelMaterial, ResourceLocation>> MATERIALS_CODEC = Codec.simpleMap(BarrelMaterial.CODEC, (Codec)ResourceLocation.CODEC, (Keyable)StringRepresentable.keys((StringRepresentable[])BarrelMaterial.values())).codec();
    public static final StreamCodec<FriendlyByteBuf, Map<BarrelMaterial, ResourceLocation>> MATERIALS_STREAM_CODEC = StreamCodec.of((buf, map) -> buf.writeMap(map, BarrelMaterial.STREAM_CODEC, (StreamEncoder)ResourceLocation.STREAM_CODEC), buf -> buf.readMap(BarrelMaterial.STREAM_CODEC, (StreamDecoder)ResourceLocation.STREAM_CODEC));

    public BarrelBlockItem(Block block) {
        this(block, new Item.Properties());
    }

    public BarrelBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static void toggleFlatTop(ItemStack stack) {
        boolean flatTop = BarrelBlockItem.isFlatTop(stack);
        BarrelBlockItem.setFlatTop(stack, !flatTop);
    }

    public static void setFlatTop(ItemStack stack, boolean flatTop) {
        if (flatTop) {
            stack.set(ModDataComponents.FLAT_TOP, (Object)true);
        } else {
            stack.remove(ModDataComponents.FLAT_TOP);
        }
    }

    public static boolean isFlatTop(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.FLAT_TOP, (Object)false);
    }

    public static void setMaterials(ItemStack barrel, Map<BarrelMaterial, ResourceLocation> materials) {
        barrel.set(ModDataComponents.BARREL_MATERIALS, Map.copyOf(materials));
    }

    public static Map<BarrelMaterial, ResourceLocation> getMaterials(ItemStack barrel) {
        return new HashMap<BarrelMaterial, ResourceLocation>((Map)barrel.getOrDefault(ModDataComponents.BARREL_MATERIALS, Map.of()));
    }

    public static void removeMaterials(ItemStack stack) {
        stack.remove(ModDataComponents.BARREL_MATERIALS);
    }

    @Override
    public Component getName(ItemStack stack) {
        Component name = BarrelBlockItem.getMaterials(stack).isEmpty() ? super.getName(stack) : BarrelBlockItem.getDisplayName(this.getDescriptionId(), null);
        if (BarrelBlockItem.isFlatTop(stack)) {
            return name.copy().append((Component)Component.translatable((String)(StorageTranslationHelper.INSTANCE.translBlockTooltipKey("barrel") + ".flat_top")));
        }
        return name;
    }

    @Override
    public boolean isTintable(ItemStack stack) {
        return BarrelBlockItem.getMaterials(stack).isEmpty();
    }
}

