/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class StorageTierUpgradeShapelessRecipe
extends ShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    private final ShapelessRecipe compose;

    public StorageTierUpgradeShapelessRecipe(ShapelessRecipe compose) {
        super(compose.getGroup(), compose.category(), compose.result, compose.getIngredients());
        this.compose = compose;
    }

    public boolean matches(CraftingInput input, Level level) {
        return super.matches(input, level) && this.getOriginalStorage(input).map(storage -> !(storage.getItem() instanceof WoodStorageBlockItem) || !WoodStorageBlockItem.isPacked(storage)).orElse(false) != false;
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack upgradedStorage = super.assemble(input, registries);
        this.getOriginalStorage(input).ifPresent(originalStorage -> upgradedStorage.applyComponents(originalStorage.getComponents()));
        Item item = upgradedStorage.getItem();
        if (item instanceof ShulkerBoxItem) {
            ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)item;
            StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, upgradedStorage);
            shulkerBoxItem.setNumberOfInventorySlots(upgradedStorage, wrapper.getDefaultNumberOfInventorySlots());
            shulkerBoxItem.setNumberOfUpgradeSlots(upgradedStorage, wrapper.getDefaultNumberOfUpgradeSlots());
        }
        return upgradedStorage;
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getOriginalStorage(CraftingInput inv) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = inv.getItem(slot);
            Item item = slotStack.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof IStorageBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModBlocks.STORAGE_TIER_UPGRADE_SHAPELESS_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, StorageTierUpgradeShapelessRecipe> {
        public Serializer() {
            super(StorageTierUpgradeShapelessRecipe::new, RecipeSerializer.SHAPELESS_RECIPE);
        }
    }
}

