/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public class StorageTierUpgradeRecipe
extends ShapedRecipe
implements IWrapperRecipe<ShapedRecipe> {
    private final ShapedRecipe compose;

    public StorageTierUpgradeRecipe(ShapedRecipe compose) {
        super(compose.getGroup(), compose.category(), compose.pattern, compose.result);
        this.compose = compose;
    }

    public boolean matches(CraftingInput input, Level level) {
        return super.matches(input, level) && this.getOriginalStorage(input).map(storage -> !(storage.getItem() instanceof WoodStorageBlockItem) || !WoodStorageBlockItem.isPacked(storage)).orElse(false) != false;
    }

    public ShapedRecipe getCompose() {
        return this.compose;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack upgradedStorage = super.assemble(input, registries);
        this.getOriginalStorage(input).ifPresent(originalStorage -> upgradedStorage.applyComponents(originalStorage.getComponents()));
        Item item = upgradedStorage.getItem();
        if (item instanceof ShulkerBoxItem) {
            ShulkerBoxItem shulkerBoxItem = (ShulkerBoxItem)item;
            StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, upgradedStorage);
            shulkerBoxItem.setNumberOfInventorySlots(upgradedStorage, wrapper.getDefaultNumberOfInventorySlots());
            shulkerBoxItem.setNumberOfUpgradeSlots(upgradedStorage, wrapper.getDefaultNumberOfUpgradeSlots());
        }
        return upgradedStorage;
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getOriginalStorage(CraftingInput input) {
        for (int slot = 0; slot < input.size(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = input.getItem(slot);
            Item item = slotStack.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof IStorageBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModBlocks.STORAGE_TIER_UPGRADE_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapedRecipe, StorageTierUpgradeRecipe> {
        public Serializer() {
            super(StorageTierUpgradeRecipe::new, RecipeSerializer.SHAPED_RECIPE);
        }
    }
}

