/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.crafting;

import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.crafting.IWrapperRecipe;
import net.p3pp3rf1y.sophisticatedcore.crafting.RecipeWrapperSerializer;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.StackStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;
import org.jetbrains.annotations.Nullable;

public class ShulkerBoxFromVanillaShapelessRecipe
extends ShapelessRecipe
implements IWrapperRecipe<ShapelessRecipe> {
    private final ShapelessRecipe compose;

    public ShulkerBoxFromVanillaShapelessRecipe(ShapelessRecipe compose) {
        super(compose.getGroup(), compose.category(), compose.result, compose.getIngredients());
        this.compose = compose;
    }

    public boolean matches(CraftingInput input, Level level) {
        return super.matches(input, level) && this.getVanillaShulkerBox(input).map(storage -> !(storage.getItem() instanceof WoodStorageBlockItem) || !WoodStorageBlockItem.isPacked(storage)).orElse(false) != false;
    }

    public ShapelessRecipe getCompose() {
        return this.compose;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack upgradedStorage = super.assemble(input, registries);
        this.getVanillaShulkerBox(input).ifPresent(vanillaShulkerBox -> {
            @Nullable IItemHandler itemCap = (IItemHandler)vanillaShulkerBox.getCapability(Capabilities.ItemHandler.ITEM);
            if (itemCap != null) {
                StackStorageWrapper wrapper = StackStorageWrapper.fromStack(registries, upgradedStorage);
                InventoryHelper.iterate((IItemHandler)itemCap, (slot, stack) -> {
                    if (!stack.isEmpty()) {
                        wrapper.getInventoryHandler().insertItem(stack, false);
                    }
                });
            }
        });
        return upgradedStorage;
    }

    public boolean isSpecial() {
        return true;
    }

    private Optional<ItemStack> getVanillaShulkerBox(CraftingInput input) {
        for (int slot = 0; slot < input.size(); ++slot) {
            BlockItem blockItem;
            ItemStack slotStack = input.getItem(slot);
            Item item = slotStack.getItem();
            if (!(item instanceof BlockItem) || !((blockItem = (BlockItem)item).getBlock() instanceof ShulkerBoxBlock)) continue;
            return Optional.of(slotStack);
        }
        return Optional.empty();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModBlocks.SHULKER_BOX_FROM_VANILLA_SHAPELESS_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends RecipeWrapperSerializer<ShapelessRecipe, ShulkerBoxFromVanillaShapelessRecipe> {
        public Serializer() {
            super(ShulkerBoxFromVanillaShapelessRecipe::new, RecipeSerializer.SHAPELESS_RECIPE);
        }
    }
}

