/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common;

import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncPlayerSettingsPayload;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsManager;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ISneakItemInteractionBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;

public class CommonEventHandler {
    private static final int AVERAGE_MAX_ITEM_ENTITY_DROP_COUNT = 20;
    private final Queue<TickTask> pendingTickTasks = Queues.newConcurrentLinkedQueue();

    public void registerHandlers() {
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(this::onPlayerChangedDimension);
        eventBus.addListener(this::onPlayerRespawn);
        eventBus.addListener(this::onBlockBreak);
        eventBus.addListener(this::onLimitedBarrelLeftClicked);
        eventBus.addListener(this::onSneakItemBlockInteraction);
        eventBus.addListener(this::onLevelTick);
    }

    private void onLimitedBarrelLeftClicked(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (!player.isCreative()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof LimitedBarrelBlock)) {
            return;
        }
        LimitedBarrelBlock limitedBarrel = (LimitedBarrelBlock)block;
        if (limitedBarrel.tryToTakeItem(state, level, pos, player)) {
            event.setCanceled(true);
        }
    }

    private void onSneakItemBlockInteraction(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getEntity().isShiftKeyDown()) {
            return;
        }
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (!(block instanceof ISneakItemInteractionBlock)) {
            return;
        }
        ISneakItemInteractionBlock sneakItemInteractionBlock = (ISneakItemInteractionBlock)block;
        if (sneakItemInteractionBlock.trySneakItemInteraction(event.getEntity(), event.getHand(), state, level, pos, event.getHitVec(), event.getItemStack())) {
            event.setCanceled(true);
        }
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void sendPlayerSettingsToClient(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            String playerTagName = "sophisticatedStorageSettings";
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SyncPlayerSettingsPayload(playerTagName, SettingsManager.getPlayerSettingsTag((Player)player, (String)playerTagName)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.sendPlayerSettingsToClient(event.getEntity());
    }

    private void onLevelTick(LevelTickEvent.Post event) {
        ServerLevel serverLevel;
        block4: {
            block3: {
                Level level;
                if (event.getLevel().isClientSide() || !((level = event.getLevel()) instanceof ServerLevel)) break block3;
                serverLevel = (ServerLevel)level;
                if (!this.pendingTickTasks.isEmpty()) break block4;
            }
            return;
        }
        Iterator it = this.pendingTickTasks.iterator();
        while (it.hasNext()) {
            TickTask tickTask = (TickTask)it.next();
            if (tickTask.getTick() > serverLevel.getServer().getTickCount()) continue;
            tickTask.run();
            it.remove();
        }
    }

    private void onBlockBreak(BlockEvent.BreakEvent event) {
        Player player = event.getPlayer();
        if (!(event.getState().getBlock() instanceof WoodStorageBlockBase) || player.isShiftKeyDown()) {
            return;
        }
        Level level = player.level();
        BlockPos pos = event.getPos();
        WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, WoodStorageBlockEntity.class).ifPresent(wbe -> {
            InventoryHandler inventoryHandler;
            int startCountingFromSlot;
            Block patt0$temp;
            ChestBlockEntity cbe;
            if (wbe.isPacked() || Boolean.TRUE.equals(Config.COMMON.dropPacked.get())) {
                return;
            }
            AtomicInteger droppedItemEntityCount = new AtomicInteger(0);
            if (wbe instanceof ChestBlockEntity && !(cbe = (ChestBlockEntity)wbe).isMainChest() && (patt0$temp = level.getBlockState(pos).getBlock()) instanceof ChestBlock) {
                ChestBlock chestBlock = (ChestBlock)patt0$temp;
                startCountingFromSlot = chestBlock.getNumberOfInventorySlots();
                inventoryHandler = cbe.getMainStorageWrapper().getInventoryHandler();
            } else {
                startCountingFromSlot = 0;
                inventoryHandler = wbe.getStorageWrapper().getInventoryHandler();
            }
            InventoryHelper.iterate((IItemHandler)inventoryHandler, (slot, stack) -> {
                if (stack.isEmpty() || slot < startCountingFromSlot) {
                    return;
                }
                droppedItemEntityCount.addAndGet((int)Math.ceil((double)stack.getCount() / (double)Math.min(stack.getMaxStackSize(), 20)));
            });
            if (droppedItemEntityCount.get() > (Integer)Config.SERVER.tooManyItemEntityDrops.get()) {
                event.setCanceled(true);
                ItemBase packingTapeItem = ModItems.PACKING_TAPE.get();
                MutableComponent packingTapeItemName = packingTapeItem.getName(new ItemStack((ItemLike)packingTapeItem)).copy().withStyle(ChatFormatting.GREEN);
                BlockState state = event.getState();
                player.sendSystemMessage(StorageTranslationHelper.INSTANCE.translStatusMessage("too_many_item_entity_drops", new Object[]{state.getBlock().getCloneItemStack(state, (HitResult)new BlockHitResult(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), Direction.DOWN, pos, true), (LevelReader)level, pos, player).getHoverName().copy().withStyle(ChatFormatting.GREEN), Component.literal((String)String.valueOf(droppedItemEntityCount.get())).withStyle(ChatFormatting.RED), packingTapeItemName}));
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    level.scheduleTick(pos, state.getBlock(), 2);
                    this.pendingTickTasks.add(new TickTask(serverLevel.getServer().getTickCount() + 2, () -> {
                        wbe.setUpdateBlockRender();
                        WorldHelper.notifyBlockUpdate((BlockEntity)wbe);
                    }));
                }
            }
        });
    }
}

