/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.p3pp3rf1y.sophisticatedcore.controller.IControllableStorage;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.inventory.CachedFailedInsertInventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.IStorageBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockBase;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.INeighborChangeListenerUpgrade;

public abstract class StorageBlockEntity
extends BlockEntity
implements IControllableStorage,
ILinkable,
ILockable,
Nameable,
ITierDisplay,
IUpgradeDisplay {
    public static final String STORAGE_WRAPPER_TAG = "storageWrapper";
    private final StorageWrapper storageWrapper = new StorageWrapper(() -> () -> ((StorageBlockEntity)this).setChanged(), () -> WorldHelper.notifyBlockUpdate((BlockEntity)this), () -> {
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }, this instanceof BarrelBlockEntity ? 4 : 1){

        public Optional<UUID> getContentsUuid() {
            if (this.contentsUuid == null) {
                this.contentsUuid = UUID.randomUUID();
                this.save();
            }
            return Optional.of(this.contentsUuid);
        }

        public ItemStack getWrappedStorageStack() {
            BlockPos pos = StorageBlockEntity.this.getBlockPos();
            BlockState state = StorageBlockEntity.this.getBlockState();
            return StorageBlockEntity.this.addWrappedStorageStackData(state.getBlock().getCloneItemStack(state, (HitResult)new BlockHitResult(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5), Direction.DOWN, pos, true), (LevelReader)StorageBlockEntity.this.getLevel(), pos, null), state);
        }

        @Override
        protected void onUpgradeRefresh() {
            Block block;
            if (StorageBlockEntity.this.canRefreshUpgrades() && (block = StorageBlockEntity.this.getBlockState().getBlock()) instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                storageBlock.setTicking(StorageBlockEntity.this.level, StorageBlockEntity.this.getBlockPos(), StorageBlockEntity.this.getBlockState(), !StorageBlockEntity.this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).isEmpty());
            }
        }

        @Override
        public int getDefaultNumberOfInventorySlots() {
            Block block = StorageBlockEntity.this.getBlockState().getBlock();
            if (block instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                return storageBlock.getNumberOfInventorySlots();
            }
            return 0;
        }

        @Override
        protected boolean isAllowedInStorage(ItemStack stack) {
            return StorageBlockEntity.this.isAllowedInStorage(stack);
        }

        @Override
        public int getDefaultNumberOfUpgradeSlots() {
            Block block = StorageBlockEntity.this.getBlockState().getBlock();
            if (block instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                return storageBlock.getNumberOfUpgradeSlots();
            }
            return 0;
        }

        public int getBaseStackSizeMultiplier() {
            int n;
            Block block = StorageBlockEntity.this.getBlockState().getBlock();
            if (block instanceof IStorageBlock) {
                IStorageBlock storageBlock = (IStorageBlock)block;
                n = storageBlock.getBaseStackSizeMultiplier();
            } else {
                n = super.getBaseStackSizeMultiplier();
            }
            return n;
        }

        public String getStorageType() {
            return StorageBlockEntity.this.getStorageType();
        }

        public Component getDisplayName() {
            return StorageBlockEntity.this.getDisplayName();
        }

        @Override
        protected boolean emptyInventorySlotsAcceptItems() {
            return !StorageBlockEntity.this.locked || StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked();
        }

        @Override
        public ITrackedContentsItemHandler getInventoryForInputOutput() {
            if (StorageBlockEntity.this.locked && StorageBlockEntity.this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
                if (StorageBlockEntity.this.contentsFilteredItemHandler == null) {
                    StorageBlockEntity.this.contentsFilteredItemHandler = new ContentsFilteredItemHandler(() -> super.getInventoryForInputOutput(), () -> StorageBlockEntity.this.getStorageWrapper().getInventoryHandler().getSlotTracker(), () -> (MemorySettingsCategory)StorageBlockEntity.this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class));
                }
                return StorageBlockEntity.this.contentsFilteredItemHandler;
            }
            return super.getInventoryForInputOutput();
        }
    };
    @Nullable
    protected Component displayName = null;
    private boolean updateBlockRender = false;
    @Nullable
    private BlockPos controllerPos = null;
    private boolean isLinkedToController = false;
    private boolean isBeingUpgraded = false;
    private boolean isDroppingContents = false;
    private boolean chunkBeingUnloaded = false;
    @Nullable
    private IItemHandler cachedFailedInsertItemHandler;
    private boolean locked = false;
    private boolean showLock = true;
    private boolean showTier = true;
    private boolean showUpgrades = false;
    @Nullable
    private ContentsFilteredItemHandler contentsFilteredItemHandler = null;

    protected abstract ContainerOpenersCounter getOpenersCounter();

    protected StorageBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends StorageBlockEntity> blockEntityType) {
        super(blockEntityType, pos, state);
        this.storageWrapper.setUpgradeCachesInvalidatedHandler(this::onUpgradeCachesInvalidated);
    }

    protected boolean canRefreshUpgrades() {
        return !this.isDroppingContents && this.level != null && !this.level.isClientSide;
    }

    protected ItemStack addWrappedStorageStackData(ItemStack cloneItemStack, BlockState state) {
        return cloneItemStack;
    }

    protected abstract String getStorageType();

    protected void onUpgradeCachesInvalidated() {
        this.invalidateCapabilities();
    }

    public boolean isOpen() {
        return this.getOpenersCounter().getOpenerCount() > 0;
    }

    public Component getCustomName() {
        return this.displayName;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveStorageWrapper(tag);
        this.saveSynchronizedData(tag);
        this.saveControllerPos(tag);
        if (this.isLinkedToController) {
            tag.putBoolean("isLinkedToController", this.isLinkedToController);
        }
    }

    private void saveStorageWrapper(CompoundTag tag) {
        tag.put(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.save(new CompoundTag()));
    }

    private void saveStorageWrapperClientData(CompoundTag tag) {
        tag.put(STORAGE_WRAPPER_TAG, (Tag)this.storageWrapper.saveData(new CompoundTag()));
    }

    protected void saveSynchronizedData(CompoundTag tag) {
        if (this.displayName != null) {
            tag.putString("displayName", Component.Serializer.toJson((Component)this.displayName, (HolderLookup.Provider)this.level.registryAccess()));
        }
        if (this.updateBlockRender) {
            tag.putBoolean("updateBlockRender", true);
        }
        if (this.locked) {
            tag.putBoolean("locked", this.locked);
        }
        if (!this.showLock) {
            tag.putBoolean("showLock", this.showLock);
        }
        if (!this.showTier) {
            tag.putBoolean("showTier", this.showTier);
        }
        if (this.showUpgrades) {
            tag.putBoolean("showUpgrades", this.showUpgrades);
        }
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator() && this.level != null) {
            this.getOpenersCounter().incrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator() && this.level != null) {
            this.getOpenersCounter().decrementOpeners(player, this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove && this.level != null) {
            this.getOpenersCounter().recheckOpeners(this.level, this.getBlockPos(), this.getBlockState());
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        Block block;
        if (this.level == null || !((block = state.getBlock()) instanceof StorageBlockBase)) {
            return;
        }
        StorageBlockBase storageBlock = (StorageBlockBase)block;
        Vec3i vec3i = storageBlock.getFacing(state).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound(null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadStorageWrapper(tag, registries);
        this.loadSynchronizedData(tag, registries);
        this.loadControllerPos(tag);
        this.isLinkedToController = NBTHelper.getBoolean((CompoundTag)tag, (String)"isLinkedToController").orElse(false);
    }

    private void loadStorageWrapper(CompoundTag tag, HolderLookup.Provider registries) {
        NBTHelper.getCompound((CompoundTag)tag, (String)STORAGE_WRAPPER_TAG).ifPresent(wrapperTag -> this.storageWrapper.load(registries, (CompoundTag)wrapperTag));
    }

    public void onLoad() {
        super.onLoad();
        this.storageWrapper.onInit();
        this.registerWithControllerOnLoad();
    }

    public void loadSynchronizedData(CompoundTag tag, HolderLookup.Provider registries) {
        this.displayName = NBTHelper.getComponent((CompoundTag)tag, (String)"displayName", (HolderLookup.Provider)registries).orElse(null);
        this.locked = NBTHelper.getBoolean((CompoundTag)tag, (String)"locked").orElse(false);
        this.showLock = NBTHelper.getBoolean((CompoundTag)tag, (String)"showLock").orElse(true);
        this.showTier = NBTHelper.getBoolean((CompoundTag)tag, (String)"showTier").orElse(true);
        this.showUpgrades = NBTHelper.getBoolean((CompoundTag)tag, (String)"showUpgrades").orElse(false);
        if (this.level != null && this.level.isClientSide) {
            if (tag.getBoolean("updateBlockRender")) {
                WorldHelper.notifyBlockUpdate((BlockEntity)this);
            }
        } else {
            this.updateBlockRender = true;
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.chunkBeingUnloaded = true;
    }

    public void setRemoved() {
        if (!this.isBeingUpgraded && !this.chunkBeingUnloaded && this.level != null) {
            this.removeFromController();
        }
        super.setRemoved();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        if (tag == null) {
            return;
        }
        this.loadStorageWrapper(tag, registries);
        this.loadSynchronizedData(tag, registries);
    }

    public void setUpdateBlockRender() {
        this.updateBlockRender = true;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveStorageWrapperClientData(tag);
        this.saveSynchronizedData(tag);
        return tag;
    }

    public static void serverTick(Level level, BlockPos blockPos, StorageBlockEntity storageBlockEntity) {
        storageBlockEntity.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(null, level, blockPos));
    }

    public StorageWrapper getStorageWrapper() {
        return this.storageWrapper;
    }

    public Component getName() {
        return this.getDisplayName();
    }

    public Component getDisplayName() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getBlockState().getBlock().getName();
    }

    protected boolean isAllowedInStorage(ItemStack stack) {
        return true;
    }

    public void changeStorageSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        int currentInventorySlots = this.getStorageWrapper().getInventoryHandler().getSlots();
        this.getStorageWrapper().changeSize(additionalInventorySlots, additionalUpgradeSlots);
        this.changeSlots(currentInventorySlots + additionalInventorySlots);
    }

    public void dropContents() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.isDroppingContents = true;
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getInventoryHandler(), (Level)this.level, (BlockPos)this.worldPosition);
        InventoryHelper.dropItems((ItemStackHandler)this.storageWrapper.getUpgradeHandler(), (Level)this.level, (BlockPos)this.worldPosition);
        this.isDroppingContents = false;
    }

    public void setCustomName(Component customName) {
        this.displayName = customName;
        this.setChanged();
    }

    @Nullable
    public IItemHandler getExternalItemHandler(@Nullable Direction side) {
        if (side == null) {
            return this.getStorageWrapper().getInventoryForInputOutput();
        }
        if (this.cachedFailedInsertItemHandler == null) {
            this.cachedFailedInsertItemHandler = new CachedFailedInsertInventoryHandler(() -> this.getStorageWrapper().getInventoryForInputOutput(), () -> this.level != null ? this.level.getGameTime() : 0L);
        }
        return this.cachedFailedInsertItemHandler;
    }

    public boolean shouldDropContents() {
        return true;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
        this.setChanged();
    }

    public Optional<BlockPos> getControllerPos() {
        return Optional.ofNullable(this.controllerPos);
    }

    public void removeControllerPos() {
        this.controllerPos = null;
        this.setChanged();
    }

    public BlockPos getStorageBlockPos() {
        return this.getBlockPos();
    }

    public Level getStorageBlockLevel() {
        return Objects.requireNonNull(this.getLevel());
    }

    public void linkToController(BlockPos controllerPos) {
        if (this.getControllerPos().isPresent()) {
            return;
        }
        this.isLinkedToController = true;
        super.linkToController(controllerPos);
        this.setChanged();
    }

    public boolean isLinked() {
        return this.isLinkedToController && this.getControllerPos().isPresent();
    }

    public void setNotLinked() {
        super.setNotLinked();
        this.isLinkedToController = false;
        this.setChanged();
    }

    public boolean canConnectStorages() {
        return !this.isLinkedToController;
    }

    public Set<BlockPos> getConnectablePositions() {
        return Collections.emptySet();
    }

    public boolean connectLinkedSelf() {
        return true;
    }

    public boolean canBeConnected() {
        return this.isLinked() || super.canBeConnected();
    }

    public void setBeingUpgraded(boolean isBeingUpgraded) {
        this.isBeingUpgraded = isBeingUpgraded;
    }

    public boolean isBeingUpgraded() {
        return this.isBeingUpgraded;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void toggleLock() {
        if (this.locked) {
            this.unlock();
        } else {
            this.lock();
        }
    }

    public boolean memorizesItemsWhenLocked() {
        return false;
    }

    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return true;
    }

    private void lock() {
        this.locked = true;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).selectSlots(0, this.getStorageWrapper().getInventoryHandler().getSlots());
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateCapabilities();
        }
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    private void unlock() {
        this.locked = false;
        if (this.memorizesItemsWhenLocked()) {
            ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).unselectAllSlots();
            ItemDisplaySettingsCategory itemDisplaySettings = (ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class);
            InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                if (stack.isEmpty()) {
                    itemDisplaySettings.itemChanged(slot.intValue());
                }
            });
        }
        this.updateEmptySlots();
        if (this.allowsEmptySlotsMatchingItemInsertsWhenLocked()) {
            this.contentsFilteredItemHandler = null;
            this.invalidateCapabilities();
        }
        this.setChanged();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowLock() {
        return this.showLock;
    }

    @Override
    public void toggleLockVisibility() {
        this.showLock = !this.showLock;
        this.setChanged();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowTier() {
        return this.showTier;
    }

    @Override
    public void toggleTierVisiblity() {
        this.showTier = !this.showTier;
        this.setChanged();
        this.setUpdateBlockRender();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public boolean shouldShowUpgrades() {
        return this.showUpgrades;
    }

    @Override
    public void toggleUpgradesVisiblity() {
        this.showUpgrades = !this.showUpgrades;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public void onNeighborChange(BlockPos neighborPos) {
        Direction direction = this.getNeighborDirection(neighborPos);
        if (direction == null) {
            return;
        }
        this.storageWrapper.getUpgradeHandler().getWrappersThatImplement(INeighborChangeListenerUpgrade.class).forEach(upgrade -> upgrade.onNeighborChange(this.level, this.worldPosition, direction));
    }

    @Nullable
    protected Direction getNeighborDirection(BlockPos neighborPos) {
        Direction direction = null;
        int normalX = Integer.signum(neighborPos.getX() - this.worldPosition.getX());
        int normalY = Integer.signum(neighborPos.getY() - this.worldPosition.getY());
        int normalZ = Integer.signum(neighborPos.getZ() - this.worldPosition.getZ());
        for (Direction value : Direction.values()) {
            Vec3i normal = value.getNormal();
            if (normal.getX() != normalX || normal.getY() != normalY || normal.getZ() != normalZ) continue;
            direction = value;
            break;
        }
        return direction;
    }

    public float getSlotFillPercentage(int slot) {
        return 0.0f;
    }

    private static class ContentsFilteredItemHandler
    implements ITrackedContentsItemHandler {
        private final Supplier<ITrackedContentsItemHandler> itemHandlerGetter;
        private final Supplier<ISlotTracker> slotTrackerGetter;
        private final Supplier<MemorySettingsCategory> memorySettingsGetter;

        private ContentsFilteredItemHandler(Supplier<ITrackedContentsItemHandler> itemHandlerGetter, Supplier<ISlotTracker> slotTrackerGetter, Supplier<MemorySettingsCategory> memorySettingsGetter) {
            this.itemHandlerGetter = itemHandlerGetter;
            this.slotTrackerGetter = slotTrackerGetter;
            this.memorySettingsGetter = memorySettingsGetter;
        }

        public int getSlots() {
            return this.itemHandlerGetter.get().getSlots();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.itemHandlerGetter.get().getStackInSlot(slot);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.matchesContents(stack)) {
                return this.itemHandlerGetter.get().insertItem(slot, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.itemHandlerGetter.get().extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.itemHandlerGetter.get().getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.matchesContents(stack) && this.itemHandlerGetter.get().isItemValid(slot, stack);
        }

        private boolean matchesContents(ItemStack stack) {
            return this.slotTrackerGetter.get().getItems().contains(stack.getItem()) || this.memorySettingsGetter.get().matchesFilter(stack);
        }

        public ItemStack insertItem(ItemStack stack, boolean simulate) {
            if (this.matchesContents(stack)) {
                return this.itemHandlerGetter.get().insertItem(stack, simulate);
            }
            return stack;
        }

        public Set<ItemStackKey> getTrackedStacks() {
            return this.itemHandlerGetter.get().getTrackedStacks();
        }

        public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
            this.itemHandlerGetter.get().registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
        }

        public void unregisterStackKeyListeners() {
            this.itemHandlerGetter.get().unregisterStackKeyListeners();
        }

        public boolean hasEmptySlots() {
            return this.itemHandlerGetter.get().hasEmptySlots();
        }

        public int getInternalSlotLimit(int slot) {
            return this.itemHandlerGetter.get().getInternalSlotLimit(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.itemHandlerGetter.get().setStackInSlot(slot, stack);
        }
    }
}

