/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.voiding.VoidUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.util.CapabilityHelper;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.RandHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class LimitedBarrelBlockEntity
extends BarrelBlockEntity
implements ICountDisplay,
IFillLevelDisplay {
    private static final String SLOT_COUNTS_TAG = "slotCounts";
    private static final String SLOT_FILL_LEVELS_TAG = "slotFillLevels";
    private static final Consumer<VoidUpgradeWrapper> VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT = voidUpgrade -> {
        voidUpgrade.getFilterLogic().setAllowByDefault(false);
        voidUpgrade.setShouldVoidOverflowDefaultOrLoadFromNbt(true);
    };
    public static final String STORAGE_TYPE = "limited_barrel";
    private long lastDepositTime = -100L;
    private final List<Integer> slotCounts = new ArrayList<Integer>();
    private final List<Float> slotFillLevels = new ArrayList<Float>();
    private Map<Integer, DyeColor> slotColors = new HashMap<Integer, DyeColor>();
    private boolean showCounts = true;
    private boolean showFillLevels = false;

    public LimitedBarrelBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, (BlockEntityType<? extends BarrelBlockEntity>)ModBlocks.LIMITED_BARREL_BLOCK_ENTITY_TYPE.get());
        this.registerUpgradeDefaults();
        this.registerClientNotificationOnCountChange();
    }

    private void registerUpgradeDefaults() {
        this.getStorageWrapper().registerUpgradeDefaultsHandler(VoidUpgradeWrapper.class, VOID_UPGRADE_VOIDING_OVERFLOW_OF_EVERYTHING_BY_DEFAULT);
    }

    private void registerClientNotificationOnCountChange() {
        this.getStorageWrapper().getInventoryHandler().addListener(slot -> WorldHelper.notifyBlockUpdate((BlockEntity)this));
    }

    @Override
    protected void onUpgradeCachesInvalidated() {
        super.onUpgradeCachesInvalidated();
        this.registerClientNotificationOnCountChange();
    }

    @Override
    public boolean shouldShowCounts() {
        return this.showCounts;
    }

    @Override
    public boolean memorizesItemsWhenLocked() {
        return true;
    }

    @Override
    public boolean allowsEmptySlotsMatchingItemInsertsWhenLocked() {
        return false;
    }

    @Override
    public void toggleCountVisibility() {
        this.showCounts = !this.showCounts;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    @Override
    public List<Integer> getSlotCounts() {
        return this.slotCounts;
    }

    @Override
    public List<Float> getSlotFillLevels() {
        return this.slotFillLevels;
    }

    @Override
    public float getSlotFillPercentage(int slot) {
        return slot > -1 && slot < this.slotFillLevels.size() ? this.slotFillLevels.get(slot).floatValue() : 0.0f;
    }

    @Override
    public boolean shouldShowFillLevels() {
        return this.showFillLevels;
    }

    @Override
    public void toggleFillLevelVisibility() {
        this.showFillLevels = !this.showFillLevels;
        this.setChanged();
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
    }

    public boolean applyDye(int slot, ItemStack dyeStack, DyeColor dyeColor, boolean applyToAll) {
        if (slot < 0 || slot >= this.getStorageWrapper().getInventoryHandler().getSlots()) {
            return false;
        }
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        if (applyToAll) {
            boolean success = false;
            for (int i = 0; i < invHandler.getSlots(); ++i) {
                success |= this.applyDye(i, dyeColor, invHandler);
            }
            if (!success) {
                return false;
            }
        } else if (!this.applyDye(slot, dyeColor, invHandler)) {
            return false;
        }
        this.setChanged();
        dyeStack.shrink(1);
        WorldHelper.notifyBlockUpdate((BlockEntity)this);
        return true;
    }

    private boolean applyDye(int slot, DyeColor dyeColor, InventoryHandler invHandler) {
        ItemStack stackInSlot = invHandler.getStackInSlot(slot);
        if (stackInSlot.isEmpty() || dyeColor.equals((Object)this.slotColors.get(slot))) {
            return false;
        }
        this.slotColors.put(slot, dyeColor);
        return true;
    }

    public int getSlotColor(int slot) {
        return this.slotColors.getOrDefault(slot, DyeColor.WHITE).getTextColor();
    }

    public boolean depositItem(Player player, InteractionHand hand, ItemStack stackInHand, int slot) {
        long gameTime = this.getLevel().getGameTime();
        boolean doubleClick = gameTime - this.lastDepositTime < 10L;
        this.lastDepositTime = gameTime;
        StorageWrapper storageWrapper = this.getStorageWrapper();
        InventoryHandler invHandler = storageWrapper.getInventoryHandler();
        ItemStack stackInSlot = invHandler.getStackInSlot(slot);
        MemorySettingsCategory memorySettings = (MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class);
        if (doubleClick) {
            return this.depositFromAllOfPlayersInventory(player, slot, invHandler, stackInSlot, memorySettings);
        }
        ItemStack result = invHandler.insertItemOnlyToSlot(slot, stackInHand, true);
        if (result.getCount() != stackInHand.getCount()) {
            result = invHandler.insertItemOnlyToSlot(slot, stackInHand, false);
            if (this.isLocked()) {
                memorySettings.selectSlot(slot);
            }
            player.setItemInHand(hand, result);
            return true;
        }
        return false;
    }

    private boolean depositFromAllOfPlayersInventory(Player player, int slot, InventoryHandler invHandler, ItemStack stackInSlot, MemorySettingsCategory memorySettings) {
        AtomicBoolean success = new AtomicBoolean(false);
        Predicate<ItemStack> memoryItemMatches = itemStack -> memorySettings.isSlotSelected(slot) && memorySettings.matchesFilter(slot, itemStack);
        CapabilityHelper.runOnItemHandler((Entity)player, playerInventory -> InventoryHelper.iterate((IItemHandler)playerInventory, (playerSlot, playerStack) -> {
            ItemStack extracted;
            ItemStack result;
            if ((stackInSlot.isEmpty() && (memoryItemMatches.test((ItemStack)playerStack) || invHandler.isFilterItem(playerStack.getItem())) || !playerStack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)playerStack)) && (result = invHandler.insertItemOnlyToSlot(slot, playerStack, true)).getCount() < playerStack.getCount() && !(extracted = playerInventory.extractItem(playerSlot.intValue(), playerStack.getCount() - result.getCount(), true)).isEmpty()) {
                invHandler.insertItemOnlyToSlot(slot, playerInventory.extractItem(playerSlot.intValue(), extracted.getCount(), false), false);
                success.set(true);
            }
        }));
        return success.get();
    }

    boolean tryToTakeItem(Player player, int slot) {
        InventoryHandler inventoryHandler = this.getStorageWrapper().getInventoryHandler();
        ItemStack stackInSlot = inventoryHandler.getStackInSlot(slot);
        if (stackInSlot.isEmpty()) {
            return false;
        }
        int countToTake = player.isShiftKeyDown() ? Math.min(stackInSlot.getMaxStackSize(), stackInSlot.getCount()) : 1;
        ItemStack stackTaken = inventoryHandler.extractItem(slot, countToTake, false);
        if (player.getInventory().add(stackTaken)) {
            this.getLevel().playSound(null, this.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (RandHelper.getRandomMinusOneToOne((RandomSource)this.getLevel().random) * 0.7f + 1.0f) * 2.0f);
        } else {
            player.drop(stackTaken, false);
        }
        return true;
    }

    @Override
    void updateOpenBlockState(BlockState state, boolean open) {
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag updateTag = super.getUpdateTag(registries);
        ArrayList sc = new ArrayList();
        ListTag sfl = new ListTag();
        InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
            sc.add((int)slot, stack.getCount());
            sfl.add(slot.intValue(), (Tag)FloatTag.valueOf((float)((float)stack.getCount() / (float)this.getStorageWrapper().getInventoryHandler().getStackLimit(slot.intValue(), stack))));
        });
        updateTag.putIntArray(SLOT_COUNTS_TAG, sc);
        updateTag.put(SLOT_FILL_LEVELS_TAG, (Tag)sfl);
        return updateTag;
    }

    @Override
    public void loadSynchronizedData(CompoundTag tag, HolderLookup.Provider registries) {
        int i;
        super.loadSynchronizedData(tag, registries);
        if (tag.contains(SLOT_COUNTS_TAG)) {
            int[] countsArray = tag.getIntArray(SLOT_COUNTS_TAG);
            if (this.slotCounts.size() != countsArray.length) {
                this.slotCounts.clear();
                for (i = 0; i < countsArray.length; ++i) {
                    this.slotCounts.add(i, countsArray[i]);
                }
            } else {
                for (i = 0; i < countsArray.length; ++i) {
                    this.slotCounts.set(i, countsArray[i]);
                }
            }
        }
        if (tag.contains(SLOT_FILL_LEVELS_TAG)) {
            ListTag fillLevelsList = tag.getList(SLOT_FILL_LEVELS_TAG, 5);
            if (this.slotFillLevels.size() != fillLevelsList.size()) {
                this.slotFillLevels.clear();
                for (i = 0; i < fillLevelsList.size(); ++i) {
                    this.slotFillLevels.add(i, Float.valueOf(fillLevelsList.getFloat(i)));
                }
            } else {
                for (i = 0; i < fillLevelsList.size(); ++i) {
                    this.slotFillLevels.set(i, Float.valueOf(fillLevelsList.getFloat(i)));
                }
            }
        }
        this.showCounts = NBTHelper.getBoolean((CompoundTag)tag, (String)"showCounts").orElse(true);
        this.showFillLevels = NBTHelper.getBoolean((CompoundTag)tag, (String)"showFillLevels").orElse(false);
        this.slotColors = NBTHelper.getMap((CompoundTag)tag, (String)"slotColors", Integer::valueOf, (tagName, t) -> Optional.of(DyeColor.byId((int)((IntTag)t).getAsInt()))).orElseGet(HashMap::new);
    }

    @Override
    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        if (!this.showCounts) {
            tag.putBoolean("showCounts", this.showCounts);
        }
        if (this.showFillLevels) {
            tag.putBoolean("showFillLevels", this.showFillLevels);
        }
        if (!this.slotColors.isEmpty()) {
            NBTHelper.putMap((CompoundTag)tag, (String)"slotColors", this.slotColors, String::valueOf, color -> IntTag.valueOf((int)color.getId()));
        }
    }

    @Override
    protected String getStorageType() {
        return STORAGE_TYPE;
    }
}

