/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.mixin;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.client.animation.KeyframeAnimation;
import com.faboslav.variantsandventures.common.client.animation.SkeletonAnimations;
import com.faboslav.variantsandventures.common.client.animation.animator.context.AnimationContextTracker;
import com.faboslav.variantsandventures.common.entity.ai.control.AbstractSkeletonLookControl;
import com.faboslav.variantsandventures.common.entity.ai.control.AbstractSkeletonMoveControl;
import com.faboslav.variantsandventures.common.entity.animation.AnimatedEntity;
import com.faboslav.variantsandventures.common.entity.pose.SkeletonEntityPose;
import com.faboslav.variantsandventures.common.mixin.SkeletonEntityMobEntityMixin;
import java.util.ArrayList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractSkeleton.class})
public abstract class AbstractSkeletonEntityMixin
extends SkeletonEntityMobEntityMixin
implements AnimatedEntity {
    private AnimationContextTracker animationContextTracker;
    private int poseTicks = 0;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
                this.animationContextTracker.add(keyframeAnimation);
            }
            this.animationContextTracker.add(this.getMovementAnimation());
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<KeyframeAnimation> getAnimations() {
        return SkeletonAnimations.ANIMATIONS;
    }

    @Override
    public KeyframeAnimation getMovementAnimation() {
        return SkeletonAnimations.WALK;
    }

    @Override
    public int getKeyframeAnimationTicks() {
        return this.poseTicks;
    }

    @Override
    public void setKeyframeAnimationTicks(int keyframeAnimationTicks) {
        this.poseTicks = keyframeAnimationTicks;
    }

    private KeyframeAnimation getKeyframeAnimationByPose() {
        KeyframeAnimation keyframeAnimation = null;
        if (this.variantsandventures$isInPose(SkeletonEntityPose.IDLE) && !this.variantsandventures$isMoving()) {
            keyframeAnimation = SkeletonAnimations.IDLE;
        } else if (this.variantsandventures$isInPose(SkeletonEntityPose.EMERGE)) {
            keyframeAnimation = SkeletonAnimations.EMERGE;
        }
        return keyframeAnimation;
    }

    private void tryToStartKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        if (this.isKeyframeAnimationRunning(keyframeAnimationToStart)) {
            return;
        }
        if (!this.level().isClientSide()) {
            this.setKeyframeAnimationTicks(keyframeAnimationToStart.getAnimationLengthInTicks());
        }
        this.startKeyframeAnimation(keyframeAnimationToStart);
    }

    private void startKeyframeAnimation(KeyframeAnimation keyframeAnimationToStart) {
        for (KeyframeAnimation keyframeAnimation : this.getAnimations()) {
            if (keyframeAnimation == keyframeAnimationToStart) continue;
            this.stopKeyframeAnimation(keyframeAnimation);
        }
        this.startKeyframeAnimation(keyframeAnimationToStart, this.tickCount);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void variantsandventures$AbstractSkeletonEntityMixin(EntityType<? extends AbstractSkeleton> entityType, Level world, CallbackInfo ci) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants) {
            this.moveControl = new AbstractSkeletonMoveControl((AbstractSkeleton)this);
            this.lookControl = new AbstractSkeletonLookControl((AbstractSkeleton)this);
        }
    }

    @Inject(method={"finalizeSpawn(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;"}, at={@At(value="HEAD")})
    public void initialize(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, SpawnGroupData entityData, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants && (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.SPAWNER || spawnReason == MobSpawnType.CHUNK_GENERATION || spawnReason == MobSpawnType.STRUCTURE)) {
            this.variantsandventures$setPose(SkeletonEntityPose.EMERGE);
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    public void variantsandventures$tickStart(CallbackInfo ci) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants) {
            KeyframeAnimation keyframeAnimationToStart;
            if (!this.level().isClientSide()) {
                this.updateKeyframeAnimationTicks();
            }
            if ((keyframeAnimationToStart = this.getKeyframeAnimationByPose()) != null) {
                this.tryToStartKeyframeAnimation(keyframeAnimationToStart);
            }
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="TAIL")})
    public void variantsandventures$tickEnd(CallbackInfo ci) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants) {
            if (this.level().isClientSide() && this.variantsandventures$isInPose(SkeletonEntityPose.EMERGE)) {
                this.variantsandventures$addDigParticles();
            }
            if (!this.level().isClientSide() && this.hasPose(SkeletonEntityPose.EMERGE.get()) && this.getKeyframeAnimationTicks() == 0) {
                this.setPose(SkeletonEntityPose.IDLE.get());
            }
        }
    }

    @Override
    public void variantsandventures$skeleton$createSpawnPacket(ServerEntity entityTrackerEntry, CallbackInfoReturnable<Packet<?>> cir) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants) {
            cir.setReturnValue((Object)new ClientboundAddEntityPacket((Entity)this, entityTrackerEntry, this.variantsandventures$isInPose(SkeletonEntityPose.EMERGE.get()) ? 1 : 0));
        }
    }

    @Override
    public void variantsandventures$skeleton$onSpawnPacket(ClientboundAddEntityPacket packet, CallbackInfo ci) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants && packet.getData() == 1) {
            this.setPose(SkeletonEntityPose.EMERGE.get());
        }
    }

    @Override
    public void variantsandventures$skeleton$isInvulnerableTo(DamageSource damageSource, CallbackInfoReturnable<Boolean> cir) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants && !((Boolean)cir.getReturnValue()).booleanValue() && this.variantsandventures$isEmerging()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void variantsandventures$skeleton$isImmuneToExplosion(CallbackInfoReturnable<Boolean> cir) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants && !((Boolean)cir.getReturnValue()).booleanValue() && this.variantsandventures$isEmerging()) {
            cir.setReturnValue((Object)true);
        }
    }

    @Override
    public void variantsandventures$skeleton$isPushable(CallbackInfoReturnable<Boolean> cir) {
        if (VariantsAndVentures.getConfig().enableKeyframeAnimationsForSkeletonAndItsVariants && !((Boolean)cir.getReturnValue()).booleanValue() && this.variantsandventures$isEmerging()) {
            cir.setReturnValue((Object)true);
        }
    }

    public void variantsandventures$setPose(Pose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        this.setPose(pose);
    }

    public void variantsandventures$setPose(SkeletonEntityPose pose) {
        if (this.level().isClientSide()) {
            return;
        }
        this.setPose(pose.get());
    }

    public boolean variantsandventures$isInPose(SkeletonEntityPose pose) {
        return this.getPose() == pose.get();
    }

    private boolean variantsandventures$isInPose(Pose pose) {
        return this.getPose() == pose;
    }

    private boolean variantsandventures$isEmerging() {
        return this.variantsandventures$isInPose(SkeletonEntityPose.EMERGE.get());
    }

    private boolean variantsandventures$isMoving() {
        return this.onGround() && this.getDeltaMovement().lengthSqr() >= 1.0E-4;
    }

    private void variantsandventures$addDigParticles() {
        RandomSource random = this.getRandom();
        BlockState blockState = this.getBlockStateOn();
        if (blockState.getRenderShape() != RenderShape.INVISIBLE) {
            for (int i = 0; i < 15; ++i) {
                double d = this.getX() + (double)Mth.randomBetween((RandomSource)random, (float)-0.5f, (float)0.5f);
                double e = this.getY();
                double f = this.getZ() + (double)Mth.randomBetween((RandomSource)random, (float)-0.5f, (float)0.5f);
                this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, blockState), d, e, f, 0.0, 0.0, 0.0);
            }
        }
    }
}

