/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.mob;

import com.faboslav.variantsandventures.common.entity.ai.GelidSnowballRangedAttackGoal;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public final class GelidEntity
extends Zombie {
    public GelidEntity(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean canSpawn(EntityType<Stray> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return GelidEntity.checkMonsterSpawnRules(type, (ServerLevelAccessor)world, (MobSpawnType)spawnReason, (BlockPos)pos, (RandomSource)random) && (spawnReason == MobSpawnType.SPAWNER || world.canSeeSky(pos));
    }

    public static AttributeSupplier.Builder createGelidAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, 35.0).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ARMOR, 2.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new GelidSnowballRangedAttackGoal(this, 10.0f));
        super.registerGoals();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.OFFHAND, Items.SNOWBALL.getDefaultInstance());
    }

    protected SoundEvent getAmbientSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_DEATH.get();
    }

    protected SoundEvent getStepSound() {
        return VariantsAndVenturesSoundEvents.ENTITY_GELID_STEP.get();
    }

    public void throwSnowball(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.getItemInHand(InteractionHand.OFF_HAND);
        Item itemInHand = itemStack.getItem();
        if (itemInHand != Items.SNOWBALL) {
            return;
        }
        itemStack.shrink(1);
        Snowball snowballEntity = new Snowball(this.level(), (LivingEntity)this);
        double d = target.getEyeY() - (double)1.1f;
        double e = target.getX() - this.getX();
        double f = d - snowballEntity.getY();
        double g = target.getZ() - this.getZ();
        double h = Math.sqrt(e * e + g * g) * (double)0.2f;
        snowballEntity.shoot(e, f + h, g, 1.6f, 7.0f);
        this.playSound(SoundEvents.SNOW_GOLEM_SHOOT, 1.0f, 0.4f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.swing(InteractionHand.OFF_HAND);
        this.level().addFreshEntity((Entity)snowballEntity);
    }

    public boolean doHurtTarget(Entity target) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(VariantsAndVenturesSoundEvents.ENTITY_GELID_ATTACK.get(), 1.0f, this.getVoicePitch());
        boolean attackResult = super.doHurtTarget(target);
        if (attackResult && this.getMainHandItem().isEmpty() && target instanceof LivingEntity && target.canFreeze()) {
            float difficulty = this.level().getCurrentDifficultyAt(this.blockPosition()).getEffectiveDifficulty();
            target.setTicksFrozen(140 * (int)difficulty);
        }
        return attackResult;
    }
}

