/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.event;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.entity.mob.ThicketEntity;
import com.faboslav.variantsandventures.common.events.entity.EntitySpawnEvent;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesEntityTypes;
import com.faboslav.variantsandventures.common.tag.VariantsAndVenturesTags;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;

public final class ThicketOnEntitySpawn {
    public static boolean handleEntitySpawn(EntitySpawnEvent event) {
        Mob entity = event.entity();
        if (event.spawnReason() == MobSpawnType.NATURAL || event.spawnReason() == MobSpawnType.SPAWNER || event.spawnReason() == MobSpawnType.CHUNK_GENERATION || event.spawnReason() == MobSpawnType.STRUCTURE) {
            if (entity.getType() != EntityType.ZOMBIE) {
                return false;
            }
            if (!VariantsAndVentures.getConfig().enableThicket || !VariantsAndVentures.getConfig().enableThicketSpawns) {
                return false;
            }
            if ((float)event.entity().blockPosition().getY() < VariantsAndVentures.getConfig().thicketMinimumYLevel) {
                return false;
            }
            if (event.entity().getRandom().nextFloat() >= VariantsAndVentures.getConfig().thicketSpawnChance) {
                return false;
            }
            LevelAccessor worldAccess = event.worldAccess();
            Holder biome = worldAccess.getBiome(entity.blockPosition());
            if (!biome.is(VariantsAndVenturesTags.HAS_THICKET)) {
                return false;
            }
            ThicketEntity thicket = (ThicketEntity)VariantsAndVenturesEntityTypes.THICKET.get().create((ServerLevel)event.worldAccess(), null, event.entity().blockPosition(), event.spawnReason(), false, false);
            if (thicket == null) {
                return false;
            }
            thicket.copyPosition((Entity)entity);
            thicket.yBodyRotO = entity.yBodyRotO;
            thicket.yBodyRot = entity.yBodyRot;
            thicket.yHeadRotO = entity.yHeadRotO;
            thicket.yHeadRot = entity.yHeadRot;
            thicket.setBaby(event.isBaby());
            worldAccess.addFreshEntity((Entity)thicket);
            return true;
        }
        return false;
    }
}

