/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.event;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.entity.mob.GelidEntity;
import com.faboslav.variantsandventures.common.events.entity.EntitySpawnEvent;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesEntityTypes;
import com.faboslav.variantsandventures.common.tag.VariantsAndVenturesTags;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;

public final class GelidOnEntitySpawn {
    public static boolean handleEntitySpawn(EntitySpawnEvent event) {
        Mob entity = event.entity();
        if (event.spawnReason() == MobSpawnType.NATURAL || event.spawnReason() == MobSpawnType.SPAWNER || event.spawnReason() == MobSpawnType.CHUNK_GENERATION || event.spawnReason() == MobSpawnType.STRUCTURE) {
            if (entity.getType() != EntityType.ZOMBIE) {
                return false;
            }
            if (!VariantsAndVentures.getConfig().enableGelid || !VariantsAndVentures.getConfig().enableGelidSpawns) {
                return false;
            }
            if (event.entity().getRandom().nextFloat() >= VariantsAndVentures.getConfig().gelidSpawnChance) {
                return false;
            }
            if ((float)event.entity().blockPosition().getY() < VariantsAndVentures.getConfig().gelidMinimumYLevel) {
                return false;
            }
            LevelAccessor worldAccess = event.worldAccess();
            Holder biome = worldAccess.getBiome(entity.blockPosition());
            if (!biome.is(VariantsAndVenturesTags.HAS_GALID)) {
                return false;
            }
            GelidEntity gelid = (GelidEntity)VariantsAndVenturesEntityTypes.GELID.get().create((ServerLevel)event.worldAccess(), null, event.entity().blockPosition(), event.spawnReason(), false, false);
            if (gelid == null) {
                return false;
            }
            gelid.copyPosition((Entity)entity);
            gelid.yBodyRotO = entity.yBodyRotO;
            gelid.yBodyRot = entity.yBodyRot;
            gelid.yHeadRotO = entity.yHeadRotO;
            gelid.yHeadRot = entity.yHeadRot;
            gelid.setBaby(event.isBaby());
            worldAccess.addFreshEntity((Entity)gelid);
            return true;
        }
        return false;
    }
}

