/*
 * Decompiled with CFR 0.152.
 */
package me.ramidzkh.mekae2.integration.jei;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import me.ramidzkh.mekae2.ae2.MekanismKey;
import mekanism.api.IMekanismAccess;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.integration.jei.IMekanismJEIHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import org.jetbrains.annotations.Nullable;
import tamaized.ae2jeiintegration.api.integrations.jei.IngredientConverter;

public class ChemicalIngredientConverter
implements IngredientConverter<ChemicalStack> {
    private final IIngredientType<ChemicalStack> ingredientType;

    public ChemicalIngredientConverter() {
        IMekanismJEIHelper mekJeiHelper = IMekanismAccess.INSTANCE.jeiHelper();
        IIngredientHelper chemicalStackHelper = mekJeiHelper.getChemicalStackHelper();
        this.ingredientType = chemicalStackHelper.getIngredientType();
    }

    public IIngredientType<ChemicalStack> getIngredientType() {
        return this.ingredientType;
    }

    @Nullable
    public ChemicalStack getIngredientFromStack(GenericStack genericStack) {
        AEKey aEKey = genericStack.what();
        if (aEKey instanceof MekanismKey) {
            MekanismKey key = (MekanismKey)aEKey;
            return key.withAmount(genericStack.amount());
        }
        return null;
    }

    @Nullable
    public GenericStack getStackFromIngredient(ChemicalStack chemicalStack) {
        MekanismKey what = MekanismKey.of(chemicalStack);
        if (what == null) {
            return null;
        }
        return new GenericStack((AEKey)what, chemicalStack.getAmount());
    }
}

