/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.dimension;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.commoble.hyperbox.dimension.TeleportHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;

public class DelayedTeleportData
extends SavedData {
    public static final String DATA_KEY = "hyperbox_delayed_events";
    public static final SavedData.Factory<DelayedTeleportData> FACTORY = new SavedData.Factory(DelayedTeleportData::create, DelayedTeleportData::load, null);
    private List<TeleportEntry> delayedTeleports = new ArrayList<TeleportEntry>();

    public static DelayedTeleportData getOrCreate(ServerLevel level) {
        return (DelayedTeleportData)level.getDataStorage().computeIfAbsent(FACTORY, DATA_KEY);
    }

    public static DelayedTeleportData load(CompoundTag nbt, HolderLookup.Provider registries) {
        return DelayedTeleportData.create();
    }

    public static DelayedTeleportData create() {
        return new DelayedTeleportData();
    }

    protected DelayedTeleportData() {
    }

    public static void tick(ServerLevel level) {
        MinecraftServer server = level.getServer();
        DelayedTeleportData eventData = DelayedTeleportData.getOrCreate(level);
        List<TeleportEntry> teleports = eventData.delayedTeleports;
        eventData.delayedTeleports = new ArrayList<TeleportEntry>();
        for (TeleportEntry entry : teleports) {
            ServerPlayer player = server.getPlayerList().getPlayer(entry.playerUUID);
            ServerLevel targetWorld = server.getLevel(entry.targetLevel);
            if (player == null || targetWorld == null || player.level() != level) continue;
            TeleportHelper.sendPlayerToDimension(player, targetWorld, entry.targetVec);
        }
    }

    public void schedulePlayerTeleport(Player player, ResourceKey<Level> destination, Vec3 targetVec) {
        this.delayedTeleports.add(new TeleportEntry(player.getGameProfile().getId(), destination, targetVec));
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        return compound;
    }

    private record TeleportEntry(UUID playerUUID, ResourceKey<Level> targetLevel, Vec3 targetVec) {
    }
}

