/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.datacomponent.StatueUpgrades;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeType;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueTags;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class UpgradeRecipe
implements Recipe<RecipeInput> {
    protected final String group;
    protected final Ingredient center;
    protected final NonNullList<Ingredient> catalysts;
    protected final ItemStack result;
    protected final boolean requireCore;
    private final UpgradeType upgradeType;
    private final int tier;
    protected final boolean showNotification;

    public UpgradeRecipe(String group, Ingredient center, NonNullList<Ingredient> catalysts, ItemStack stack, boolean requireCore, UpgradeType upgradeType, int tier, boolean showNotification) {
        this.group = group;
        this.center = center;
        this.catalysts = catalysts;
        this.result = stack;
        this.requireCore = requireCore;
        this.upgradeType = upgradeType;
        this.tier = tier;
        this.showNotification = showNotification;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList nonnulllist = NonNullList.create();
        nonnulllist.add((Object)this.center);
        if (this.requireCore) {
            nonnulllist.add((Object)Ingredient.of(StatueTags.STATUE_CORE));
        }
        nonnulllist.addAll(this.catalysts);
        return nonnulllist;
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public Ingredient getCenter() {
        return this.center;
    }

    public NonNullList<Ingredient> getCatalysts() {
        return this.catalysts;
    }

    public boolean requiresCore() {
        return this.requireCore;
    }

    public int getTier() {
        return this.tier;
    }

    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public MutableComponent getUpgradeName() {
        String descriptionID = "statues.upgrade." + this.getUpgradeType().getSerializedName() + ".name";
        MutableComponent component = Component.translatable((String)"statues.upgrade.upgrade_type").withStyle(ChatFormatting.YELLOW);
        component.append(" : ");
        component = component.append((Component)Component.translatable((String)descriptionID).withStyle(ChatFormatting.GRAY));
        if (this.getTier() > 0) {
            component.append(" ").append((Component)Component.translatable((String)("enchantment.level." + this.getTier())));
        }
        return component;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        ItemStack coreStack;
        ItemStack statueStack = recipeInput.getItem(0);
        if (!this.center.test(statueStack)) {
            return false;
        }
        if (statueStack.getItem() instanceof StatueBlockItem) {
            boolean upgraded = (Boolean)statueStack.getOrDefault(StatueDataComponents.UPGRADED, (Object)false);
            StatueStats stats = (StatueStats)statueStack.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty());
            if (this.upgradeType.requiresUpgrade() ? !upgraded || stats.upgradeSlots() < 1 : this.upgradeType == UpgradeType.UPGRADE && upgraded) {
                return false;
            }
            StatueUpgrades statueUpgrades = (StatueUpgrades)statueStack.getOrDefault(StatueDataComponents.UPGRADES, (Object)StatueUpgrades.empty());
            if (this.tier != -1 && this.tier != statueUpgrades.getUpgradeLevel(this.upgradeType.name().toLowerCase(Locale.ROOT))) {
                return false;
            }
            if (statueUpgrades.getUpgradeLevel(this.upgradeType.name().toLowerCase(Locale.ROOT)) >= this.upgradeType.getCap()) {
                return false;
            }
        }
        if (this.requireCore && !(coreStack = recipeInput.getItem(1)).is(StatueTags.STATUE_CORE)) {
            return false;
        }
        if (this.catalysts.isEmpty()) {
            for (int j = 2; j < 6; ++j) {
                ItemStack itemstack = recipeInput.getItem(j);
                if (itemstack.isEmpty()) continue;
                return false;
            }
            return true;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int itemCount = 0;
        for (int j = 2; j < 6; ++j) {
            ItemStack itemstack = recipeInput.getItem(j);
            if (itemstack.isEmpty()) continue;
            ++itemCount;
            inputs.add(itemstack);
        }
        return itemCount == this.catalysts.size() && RecipeMatcher.findMatches(inputs, this.catalysts) != null;
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider lookupProvider) {
        return this.getResultItem(lookupProvider).copy();
    }

    public boolean canCraftInDimensions(int x, int y) {
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider lookupProvider) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return StatuesRecipes.UPGRADE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return StatuesRecipes.UPGRADE_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeRecipe> {
        private static final MapCodec<UpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("center").forGetter(recipe -> recipe.center), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("catalysts").flatXmap(array -> {
            Object[] aingredient = (Ingredient[])array.toArray(Ingredient[]::new);
            return aingredient.length > 4 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(4)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(recipe -> recipe.catalysts), (App)ItemStack.SINGLE_ITEM_CODEC.optionalFieldOf("result", (Object)ItemStack.EMPTY).forGetter(recipe -> recipe.result), (App)Codec.BOOL.optionalFieldOf("requireCore", (Object)false).forGetter(recipe -> recipe.requireCore), (App)UpgradeType.CODEC.optionalFieldOf("upgradeType", (Object)UpgradeType.CRAFTING).forGetter(recipe -> recipe.upgradeType), (App)Codec.INT.optionalFieldOf("tier", (Object)-1).forGetter(recipe -> recipe.tier), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)true).forGetter(recipe -> recipe.showNotification)).apply((Applicative)instance, UpgradeRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, UpgradeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<UpgradeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, UpgradeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static UpgradeRecipe fromNetwork(RegistryFriendlyByteBuf byteBuf) {
            String s = byteBuf.readUtf(Short.MAX_VALUE);
            Ingredient center = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)byteBuf);
            int i = byteBuf.readVarInt();
            NonNullList catalist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            for (int j = 0; j < catalist.size(); ++j) {
                catalist.set(j, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)byteBuf)));
            }
            ItemStack result = (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)byteBuf);
            boolean requireCore = byteBuf.readBoolean();
            int type = byteBuf.readVarInt();
            UpgradeType upgradeType = UpgradeType.values()[type];
            int tier = byteBuf.readVarInt();
            boolean showNotification = byteBuf.readBoolean();
            return new UpgradeRecipe(s, center, (NonNullList<Ingredient>)catalist, result, requireCore, upgradeType, tier, showNotification);
        }

        public static void toNetwork(RegistryFriendlyByteBuf byteBuf, UpgradeRecipe recipe) {
            byteBuf.writeUtf(recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.center);
            byteBuf.writeVarInt(recipe.catalysts.size());
            for (Ingredient ingredient : recipe.catalysts) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)byteBuf, (Object)ingredient);
            }
            ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)byteBuf, (Object)recipe.result);
            byteBuf.writeBoolean(recipe.requireCore);
            byteBuf.writeVarInt(recipe.upgradeType.ordinal());
            byteBuf.writeVarInt(recipe.tier);
            byteBuf.writeBoolean(recipe.showNotification);
        }
    }
}

