/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.shynieke.statues.recipe.StatuesRecipes;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class HardcoreRecipe
extends ShapedRecipe {
    final ShapedRecipePattern pattern;
    final ItemStack result;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public HardcoreRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification) {
        super(group, category, pattern, result);
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = result;
        this.showNotification = showNotification;
    }

    public RecipeSerializer<?> getSerializer() {
        return StatuesRecipes.HARDCORE_SHAPED_SERIALIZER.get();
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        return super.matches(craftingInput, level) && level != null && level.getLevelData().isHardcore();
    }

    public ItemStack getResultItem(HolderLookup.Provider lookupProvider) {
        ItemStack resultStack = super.getResultItem(lookupProvider);
        ItemLore lore = ItemLore.EMPTY;
        lore = lore.withLineAdded((Component)Component.literal((String)"Only craftable in Hardcore Mode").withStyle(ChatFormatting.DARK_PURPLE));
        resultStack.set(DataComponents.LORE, (Object)lore);
        return resultStack;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider lookupProvider) {
        return this.result.copy();
    }

    public static class Serializer
    implements RecipeSerializer<HardcoreRecipe> {
        public static final MapCodec<HardcoreRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_311729_ -> p_311729_.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(p_311732_ -> p_311732_.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(p_311733_ -> p_311733_.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_311730_ -> p_311730_.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(p_311731_ -> p_311731_.showNotification)).apply((Applicative)instance, HardcoreRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, HardcoreRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<HardcoreRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, HardcoreRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static HardcoreRecipe fromNetwork(RegistryFriendlyByteBuf byteBuf) {
            String s = byteBuf.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)byteBuf.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern recipePattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)byteBuf);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)byteBuf);
            boolean flag = byteBuf.readBoolean();
            return new HardcoreRecipe(s, craftingbookcategory, recipePattern, itemstack, flag);
        }

        public static void toNetwork(RegistryFriendlyByteBuf byteBuf, HardcoreRecipe hardcoreRecipe) {
            byteBuf.writeUtf(hardcoreRecipe.group);
            byteBuf.writeEnum((Enum)hardcoreRecipe.category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)byteBuf, (Object)hardcoreRecipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)byteBuf, (Object)hardcoreRecipe.result);
            byteBuf.writeBoolean(hardcoreRecipe.showNotification);
        }
    }
}

