/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.network.handler;

import com.shynieke.statues.client.screen.PlayerPoseScreen;
import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.network.message.PlayerStatueScreenData;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleData(PlayerStatueScreenData data, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft mc = Minecraft.getInstance();
            Entity entity = mc.level.getEntity(data.entityID());
            if (entity instanceof PlayerStatue) {
                PlayerStatue playerStatue = (PlayerStatue)entity;
                PlayerPoseScreen.openScreen(playerStatue);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"statues.networking.player_statue_screen.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

