/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.lootmodifiers;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueLootModifiers;
import com.shynieke.statues.registry.StatueTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class CityStatuesLootModifier
extends LootModifier {
    public static final Supplier<MapCodec<CityStatuesLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> CityStatuesLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, CityStatuesLootModifier::new)));

    public CityStatuesLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random;
        HolderSet.Named tag;
        Optional randomItem;
        Optional optionalTag;
        if (((Boolean)StatuesConfig.COMMON.ancientCityLoot.get()).booleanValue() && (optionalTag = BuiltInRegistries.ITEM.getTag(StatueTags.STATUES_ITEMS)).isPresent() && (randomItem = (tag = (HolderSet.Named)optionalTag.get()).getRandomElement(random = context.getRandom())).isPresent()) {
            ItemStack statueStack = new ItemStack((Holder)randomItem.get());
            if (random.nextDouble() <= (Double)StatuesConfig.COMMON.ancientCityLootChance.get() && !statueStack.is(Items.EGG)) {
                StatueStats stats = new StatueStats(1, 2, this.getRandInRange(context.getRandom(), 6, 16));
                statueStack.set(StatueDataComponents.UPGRADED, (Object)true);
                statueStack.set(StatueDataComponents.STATS, (Object)stats);
                generatedLoot.add((Object)statueStack);
            }
        }
        return generatedLoot;
    }

    public int getRandInRange(RandomSource random, int min, int max) {
        return random.nextIntBetweenInclusive(min, max);
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return StatueLootModifiers.STATUES_CITY_LOOT.get();
    }
}

