/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.items;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.datacomponent.StatueUpgrades;
import com.shynieke.statues.registry.StatueDataComponents;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class StatueBlockItem
extends BlockItem {
    public StatueBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public boolean isBaby() {
        AbstractStatueBase statueBase;
        Block block = this.getBlock();
        return block instanceof AbstractStatueBase && (statueBase = (AbstractStatueBase)block).isBaby();
    }

    public boolean isHiddenStatue() {
        AbstractStatueBase statueBase;
        Block block = this.getBlock();
        return block instanceof AbstractStatueBase && (statueBase = (AbstractStatueBase)block).isHiddenStatue();
    }

    public EntityType<?> getEntity() {
        EntityType<?> entityType;
        Block block = this.getBlock();
        if (block instanceof AbstractStatueBase) {
            AbstractStatueBase statueBase = (AbstractStatueBase)block;
            entityType = statueBase.getEntity();
        } else {
            entityType = null;
        }
        return entityType;
    }

    public boolean matchesEntity(LivingEntity livingEntity) {
        return this.getEntity() != null && this.getEntity() == livingEntity.getType() && livingEntity.isBaby() == this.isBaby();
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockState state = super.getPlacementState(context);
        ItemStack stack = context.getItemInHand();
        if (state != null && state.getBlock() instanceof AbstractStatueBase && stack.has(StatueDataComponents.UPGRADED) && ((Boolean)stack.get(StatueDataComponents.UPGRADED)).booleanValue()) {
            state = (BlockState)state.setValue((Property)AbstractStatueBase.INTERACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag tooltipFlag) {
        StatueUpgrades upgrades;
        Map<String, Short> upgradeMap;
        super.appendHoverText(stack, context, components, tooltipFlag);
        if (stack.has(StatueDataComponents.STATS)) {
            StatueStats stats = (StatueStats)stack.get(StatueDataComponents.STATS);
            components.add((Component)Component.translatable((String)"statues.info.level").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)String.valueOf(stats.level())).withStyle(ChatFormatting.YELLOW)));
            components.add((Component)Component.translatable((String)"statues.info.kills").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)String.valueOf(stats.killCount())).withStyle(ChatFormatting.YELLOW)));
            components.add((Component)Component.translatable((String)"statues.info.upgrade_slots").withStyle(ChatFormatting.GOLD).append(" ").append((Component)Component.literal((String)String.valueOf(stats.upgradeSlots())).withStyle(ChatFormatting.YELLOW)));
        }
        if (!(upgradeMap = (upgrades = (StatueUpgrades)stack.getOrDefault(StatueDataComponents.UPGRADES, (Object)StatueUpgrades.empty())).upgradeMap()).isEmpty()) {
            components.addAll(upgrades.getUpgradeNames());
        }
    }
}

