/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.items;

import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.client.render.PlayerBEWLR;
import com.shynieke.statues.items.StatueBlockItem;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class PlayerStatueBlockItem
extends StatueBlockItem {
    public PlayerStatueBlockItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public Component getName(ItemStack stack) {
        ResolvableProfile resolvableprofile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        return resolvableprofile != null && resolvableprofile.name().isPresent() ? Component.translatable((String)(this.getDescriptionId() + ".named"), (Object[])new Object[]{resolvableprofile.name().get()}) : super.getName(stack);
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        ResolvableProfile resolvableprofile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        if (resolvableprofile != null && !resolvableprofile.isResolved()) {
            PlayerBlockEntity.resolve(resolvableprofile).thenAcceptAsync(profile -> stack.set(DataComponents.PROFILE, profile), PlayerBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        }
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new PlayerBEWLR(new BlockEntityRendererProvider.Context(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getBlockRenderer(), Minecraft.getInstance().getItemRenderer(), Minecraft.getInstance().getEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels(), Minecraft.getInstance().font));
            }
        });
    }
}

