/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.fakeplayer;

import com.mojang.authlib.GameProfile;
import com.shynieke.statues.Reference;
import java.lang.ref.WeakReference;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class StatueFakePlayer
extends FakePlayer {
    private static WeakReference<StatueFakePlayer> INSTANCE;

    public StatueFakePlayer(ServerLevel serverLevel, GameProfile profile) {
        super(serverLevel, profile);
    }

    public static <R> R useFakePlayer(ServerLevel serverLevel, Function<StatueFakePlayer, R> fakePlayerConsumer) {
        StatueFakePlayer actual;
        StatueFakePlayer statueFakePlayer = actual = INSTANCE == null ? null : (StatueFakePlayer)((Object)INSTANCE.get());
        if (actual == null) {
            actual = new StatueFakePlayer(serverLevel, Reference.GAME_PROFILE);
            INSTANCE = new WeakReference<StatueFakePlayer>(actual);
        }
        StatueFakePlayer player = actual;
        player.setServerLevel(serverLevel);
        R result = fakePlayerConsumer.apply(player);
        player.setServerLevel(serverLevel.getServer().overworld());
        return result;
    }

    public boolean canBeAffected(MobEffectInstance mobEffectInstance) {
        return false;
    }

    public static void unload(ServerLevel serverLevel) {
        StatueFakePlayer actual;
        StatueFakePlayer statueFakePlayer = actual = INSTANCE == null ? null : (StatueFakePlayer)((Object)INSTANCE.get());
        if (actual != null && actual.level() == serverLevel) {
            actual.setServerLevel(serverLevel.getServer().overworld());
        }
    }

    public boolean isAlliedTo(Team team) {
        return false;
    }

    @Nullable
    public PlayerTeam getTeam() {
        return null;
    }
}

