/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import com.shynieke.statues.Statues;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.client.screen.PlayerStatueData;
import com.shynieke.statues.network.message.PlayerStatueScreenData;
import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.registry.StatueSerializers;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class PlayerStatue
extends LivingEntity {
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);
    private static final String DEFAULT_MODEL = PlayerStatueData.MODEL_TYPE.AUTO.name();
    private static final EntityDataAccessor<Optional<ResolvableProfile>> RESOLVABLE_PROFILE = SynchedEntityData.defineId(PlayerStatue.class, StatueSerializers.OPTIONAL_RESOLVABLE_PROFILE.get());
    public static final EntityDataAccessor<Byte> STATUS = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public static final EntityDataAccessor<Float> Y_OFFSET = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Rotations> HEAD_ROTATION = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> BODY_ROTATION = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> LEFT_ARM_ROTATION = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> RIGHT_ARM_ROTATION = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> LEFT_LEG_ROTATION = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<Rotations> RIGHT_LEG_ROTATION = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.ROTATIONS);
    public static final EntityDataAccessor<String> MODEL_TYPE = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Optional<UUID>> LOCKED_BY_UUID = SynchedEntityData.defineId(PlayerStatue.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private final NonNullList<ItemStack> handItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    public long punchCooldown;
    private int disabledSlots;
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFTARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHTARM_ROTATION;
    private Rotations leftLegRotation = DEFAULT_LEFTLEG_ROTATION;
    private Rotations rightLegRotation = DEFAULT_RIGHTLEG_ROTATION;
    public int clientLock = 0;

    public PlayerStatue(EntityType<? extends PlayerStatue> entityType, Level level) {
        super(entityType, level);
    }

    public void setYRot(float yRot) {
        if (this.clientLock > 0) {
            return;
        }
        super.setYRot(yRot);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PlayerStatue.createLivingAttributes().add(Attributes.STEP_HEIGHT, 0.0);
    }

    public PlayerStatue(Level level, double posX, double posY, double posZ) {
        this(StatueRegistry.PLAYER_STATUE_ENTITY.get(), level);
        this.setPos(posX, posY, posZ);
    }

    public void refreshDimensions() {
        double d0 = this.getX();
        double d1 = this.getY();
        double d2 = this.getZ();
        super.refreshDimensions();
        this.setPos(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isNoGravity();
    }

    public boolean isNoGravity() {
        return super.isNoGravity();
    }

    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(RESOLVABLE_PROFILE, Optional.empty());
        builder.define(STATUS, (Object)0);
        builder.define(Y_OFFSET, (Object)Float.valueOf(0.0f));
        builder.define(HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        builder.define(BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
        builder.define(LEFT_ARM_ROTATION, (Object)DEFAULT_LEFTARM_ROTATION);
        builder.define(RIGHT_ARM_ROTATION, (Object)DEFAULT_RIGHTARM_ROTATION);
        builder.define(LEFT_LEG_ROTATION, (Object)DEFAULT_LEFTLEG_ROTATION);
        builder.define(RIGHT_LEG_ROTATION, (Object)DEFAULT_RIGHTLEG_ROTATION);
        builder.define(LOCKED_BY_UUID, Optional.empty());
        builder.define(MODEL_TYPE, (Object)DEFAULT_MODEL);
    }

    public Optional<ResolvableProfile> getGameProfile() {
        return (Optional)this.entityData.get(RESOLVABLE_PROFILE);
    }

    public void setGameProfile(ResolvableProfile profile) {
        this.entityData.set(RESOLVABLE_PROFILE, Optional.of(profile));
    }

    @Nullable
    public boolean isLocked() {
        return ((Optional)this.entityData.get(LOCKED_BY_UUID)).isPresent();
    }

    @Nullable
    public UUID getLockedBy() {
        return ((Optional)this.entityData.get(LOCKED_BY_UUID)).orElse(Util.NIL_UUID);
    }

    public String getModel() {
        return (String)this.entityData.get(MODEL_TYPE);
    }

    public void setModel(String model) {
        this.entityData.set(MODEL_TYPE, (Object)model);
    }

    public boolean canOpenUI(Player player) {
        UUID lockedBy = this.getLockedBy();
        return lockedBy.equals(Util.NIL_UUID) || lockedBy != Util.NIL_UUID && lockedBy.equals(player.getUUID());
    }

    public void setLockedBy(@Nullable UUID uuid) {
        if (uuid == null) {
            this.setUnlocked();
        } else {
            this.entityData.set(LOCKED_BY_UUID, Optional.of(uuid));
        }
    }

    public void setUnlocked() {
        this.entityData.set(LOCKED_BY_UUID, Optional.empty());
    }

    public void setYOffset(float yOffset) {
        this.entityData.set(Y_OFFSET, (Object)Float.valueOf(Mth.clamp((float)yOffset, (float)-1.0f, (float)1.0f)));
    }

    public float getYOffsetData() {
        return ((Float)this.entityData.get(Y_OFFSET)).floatValue();
    }

    public Iterable<ItemStack> getHandSlots() {
        return this.handItems;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.armorItems;
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        switch (slotIn.getType()) {
            case HAND: {
                return (ItemStack)this.handItems.get(slotIn.getIndex());
            }
            case HUMANOID_ARMOR: {
                return (ItemStack)this.armorItems.get(slotIn.getIndex());
            }
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        this.verifyEquippedItem(stack);
        switch (slotIn.getType()) {
            case HAND: {
                this.onEquipItem(slotIn, (ItemStack)this.handItems.set(slotIn.getIndex(), (Object)stack), stack);
                break;
            }
            case HUMANOID_ARMOR: {
                this.onEquipItem(slotIn, (ItemStack)this.armorItems.set(slotIn.getIndex(), (Object)stack), stack);
            }
        }
    }

    public boolean canTakeItem(ItemStack itemstackIn) {
        EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(itemstackIn);
        return this.getItemBySlot(equipmentSlot).isEmpty() && !this.isDisabled(equipmentSlot);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("profileExists", ((Optional)this.entityData.get(RESOLVABLE_PROFILE)).isPresent());
        if (this.getGameProfile().isPresent()) {
            ResolvableProfile.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((ResolvableProfile)((Optional)this.entityData.get(RESOLVABLE_PROFILE)).get())).resultOrPartial(arg_0 -> ((Logger)Statues.LOGGER).error(arg_0)).ifPresent(profile -> compound.put("profile", profile));
        }
        compound.putFloat("yOffset", this.getYOffsetData());
        compound.putString("Model", this.getModel());
        ListTag listnbt = new ListTag();
        for (ItemStack itemstack : this.armorItems) {
            CompoundTag compoundnbt = new CompoundTag();
            if (!itemstack.isEmpty()) {
                itemstack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)compoundnbt);
            }
            listnbt.add((Object)compoundnbt);
        }
        compound.put("ArmorItems", (Tag)listnbt);
        ListTag listnbt1 = new ListTag();
        for (ItemStack itemstack1 : this.handItems) {
            CompoundTag compoundnbt1 = new CompoundTag();
            if (!itemstack1.isEmpty()) {
                itemstack1.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)compoundnbt1);
            }
            listnbt1.add((Object)compoundnbt1);
        }
        compound.putBoolean("Locked", this.isLocked());
        if (this.isLocked() && this.getLockedBy() != null) {
            compound.putUUID("LockedBy", this.getLockedBy());
        }
        compound.put("HandItems", (Tag)listnbt1);
        compound.putBoolean("Small", this.isSmall());
        compound.putInt("DisabledSlots", this.disabledSlots);
        compound.put("Pose", (Tag)this.writePose());
    }

    public CompoundTag saveWithoutId(CompoundTag compound) {
        return super.saveWithoutId(compound);
    }

    public void load(CompoundTag compound) {
        super.load(compound);
        boolean profileExists = compound.getBoolean("profileExists");
        if (profileExists) {
            this.entityData.set(RESOLVABLE_PROFILE, (Object)ResolvableProfile.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("profile")).resultOrPartial(p_332637_ -> Statues.LOGGER.error("Failed to load profile from player statue: {}", p_332637_)));
        } else {
            this.entityData.set(RESOLVABLE_PROFILE, Optional.empty());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (this.clientLock > 0) {
            return;
        }
        super.readAdditionalSaveData(compound);
        this.setYOffset(compound.getFloat("yOffset"));
        this.setModel(compound.getString("Model"));
        if (compound.contains("ArmorItems", 9)) {
            ListTag listnbt = compound.getList("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)listnbt.getCompound(i)));
            }
        }
        if (compound.getBoolean("Locked")) {
            UUID uuid;
            if (compound.hasUUID("LockedBy")) {
                uuid = compound.getUUID("LockedBy");
            } else {
                String s = compound.getString("LockedBy");
                uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
            }
            if (uuid != null) {
                this.setLockedBy(uuid);
            }
        }
        if (compound.contains("HandItems", 9)) {
            ListTag listnbt1 = compound.getList("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, (Object)ItemStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)listnbt1.getCompound(j)));
            }
        }
        this.setSmall(compound.getBoolean("Small"));
        this.disabledSlots = compound.getInt("DisabledSlots");
        this.noPhysics = !this.hasPhysics();
        CompoundTag compoundnbt = compound.getCompound("Pose");
        this.readPose(compoundnbt);
    }

    private void readPose(CompoundTag tagCompound) {
        ListTag listnbt = tagCompound.getList("Head", 5);
        this.setHeadRotation(listnbt.isEmpty() ? DEFAULT_HEAD_ROTATION : new Rotations(listnbt));
        ListTag listnbt1 = tagCompound.getList("Body", 5);
        this.setBodyRotation(listnbt1.isEmpty() ? DEFAULT_BODY_ROTATION : new Rotations(listnbt1));
        ListTag listnbt2 = tagCompound.getList("LeftArm", 5);
        this.setLeftArmRotation(listnbt2.isEmpty() ? DEFAULT_LEFTARM_ROTATION : new Rotations(listnbt2));
        ListTag listnbt3 = tagCompound.getList("RightArm", 5);
        this.setRightArmRotation(listnbt3.isEmpty() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(listnbt3));
        ListTag listnbt4 = tagCompound.getList("LeftLeg", 5);
        this.setLeftLegRotation(listnbt4.isEmpty() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(listnbt4));
        ListTag listnbt5 = tagCompound.getList("RightLeg", 5);
        this.setRightLegRotation(listnbt5.isEmpty() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(listnbt5));
    }

    private CompoundTag writePose() {
        CompoundTag compoundnbt = new CompoundTag();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            compoundnbt.put("Head", (Tag)this.headRotation.save());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            compoundnbt.put("Body", (Tag)this.bodyRotation.save());
        }
        if (!DEFAULT_LEFTARM_ROTATION.equals((Object)this.leftArmRotation)) {
            compoundnbt.put("LeftArm", (Tag)this.leftArmRotation.save());
        }
        if (!DEFAULT_RIGHTARM_ROTATION.equals((Object)this.rightArmRotation)) {
            compoundnbt.put("RightArm", (Tag)this.rightArmRotation.save());
        }
        if (!DEFAULT_LEFTLEG_ROTATION.equals((Object)this.leftLegRotation)) {
            compoundnbt.put("LeftLeg", (Tag)this.leftLegRotation.save());
        }
        if (!DEFAULT_RIGHTLEG_ROTATION.equals((Object)this.rightLegRotation)) {
            compoundnbt.put("RightLeg", (Tag)this.rightLegRotation.save());
        }
        return compoundnbt;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    public void setCustomName(@Nullable Component name) {
        if (name != null && !this.isLocked()) {
            super.setCustomName(name);
            String username = name.getString().toLowerCase(Locale.ROOT);
            PlayerBlockEntity.fetchGameProfile(username).thenAccept(profile -> this.setGameProfile(new ResolvableProfile(profile.orElse(new GameProfile(Util.NIL_UUID, username)))));
        }
    }

    public InteractionResult interactAt(Player player, Vec3 vec, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!this.level().isClientSide && player != null && this.canOpenUI(player)) {
                ((ServerPlayer)player).connection.send((CustomPacketPayload)new PlayerStatueScreenData(this.getId()));
            }
        } else if (itemstack.getItem() != Items.NAME_TAG) {
            if (player.isSpectator()) {
                return InteractionResult.SUCCESS;
            }
            if (player.level().isClientSide) {
                return InteractionResult.CONSUME;
            }
            if (!this.isLocked()) {
                EquipmentSlot equipmentSlot = this.getEquipmentSlotForItem(itemstack);
                if (itemstack.isEmpty()) {
                    EquipmentSlot equipmentslot2;
                    EquipmentSlot equipmentslot1 = this.getClickedSlot(vec);
                    EquipmentSlot equipmentSlot2 = equipmentslot2 = this.isDisabled(equipmentslot1) ? equipmentSlot : equipmentslot1;
                    if (this.hasItemInSlot(equipmentslot2) && this.swapItem(player, equipmentslot2, itemstack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                } else {
                    if (this.isDisabled(equipmentSlot)) {
                        return InteractionResult.FAIL;
                    }
                    if (this.swapItem(player, equipmentSlot, itemstack, hand)) {
                        return InteractionResult.SUCCESS;
                    }
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 clicked) {
        EquipmentSlot equipmentSlot = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = flag ? clicked.y * 2.0 : clicked.y;
        EquipmentSlot equipmentSlot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.hasItemInSlot(equipmentSlot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.hasItemInSlot(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.hasItemInSlot(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.hasItemInSlot(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.hasItemInSlot(EquipmentSlot.MAINHAND)) return equipmentSlot;
        if (!this.hasItemInSlot(EquipmentSlot.OFFHAND)) return equipmentSlot;
        return EquipmentSlot.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlot slotIn) {
        return (this.disabledSlots & 1 << slotIn.getFilterFlag()) != 0;
    }

    private boolean swapItem(Player player, EquipmentSlot slot, ItemStack stack, InteractionHand hand) {
        ItemStack itemstack = this.getItemBySlot(slot);
        if (!itemstack.isEmpty() && (this.disabledSlots & 1 << slot.getFilterFlag() + 8) != 0) {
            return false;
        }
        if (itemstack.isEmpty() && (this.disabledSlots & 1 << slot.getFilterFlag() + 16) != 0) {
            return false;
        }
        if (player.hasInfiniteMaterials() && itemstack.isEmpty() && !stack.isEmpty()) {
            ItemStack itemstack2 = stack.copy();
            itemstack2.setCount(1);
            this.setItemSlot(slot, itemstack2);
            return true;
        }
        if (!stack.isEmpty() && stack.getCount() > 1) {
            if (!itemstack.isEmpty()) {
                return false;
            }
            ItemStack itemstack1 = stack.copy();
            itemstack1.setCount(1);
            this.setItemSlot(slot, itemstack1);
            stack.shrink(1);
            return true;
        }
        this.setItemSlot(slot, stack);
        player.setItemInHand(hand, itemstack);
        return true;
    }

    public boolean isInvulnerable() {
        return this.isLocked() || super.isInvulnerable();
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (this.isLocked()) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isRemoved()) {
            return false;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                this.remove(Entity.RemovalReason.DISCARDED);
                return false;
            }
            if (!this.isInvulnerableTo(source)) {
                if (source.is(DamageTypeTags.IS_EXPLOSION)) {
                    this.brokenByAnything(serverlevel, source);
                    this.remove(Entity.RemovalReason.KILLED);
                    return false;
                }
                if (source.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
                    if (this.isOnFire()) {
                        this.causeDamage(serverlevel, source, 0.15f);
                    } else {
                        this.setRemainingFireTicks(100);
                    }
                    return false;
                }
                if (source.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
                    this.causeDamage(serverlevel, source, 4.0f);
                    return false;
                }
                boolean flag = source.getDirectEntity() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)source.getDirectEntity()).getPierceLevel() > 0;
                boolean flag2 = "player".equals(source.getMsgId());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.getEntity() instanceof Player && !((Player)source.getEntity()).getAbilities().mayBuild) {
                    return false;
                }
                if (source.isCreativePlayer()) {
                    this.playBrokenSound();
                    this.playParticles();
                    this.remove(Entity.RemovalReason.KILLED);
                    return flag1;
                }
                long i = this.level().getGameTime();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.breakPlayerStatue(serverlevel, source);
                    this.playParticles();
                    this.remove(Entity.RemovalReason.KILLED);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.punchCooldown = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderAtSqrDistance(double distance) {
        double d0 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    private void playParticles() {
        if (this.level() instanceof ServerLevel) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, ((PlayerStatueBlock)((Object)StatueRegistry.PLAYER_STATUE.get())).defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, (double)(this.getBbWidth() / 4.0f), (double)(this.getBbHeight() / 4.0f), (double)(this.getBbWidth() / 4.0f), 0.05);
        }
    }

    private void causeDamage(ServerLevel serverLevel, DamageSource source, float p_213817_2_) {
        float f = this.getHealth();
        if ((f -= p_213817_2_) <= 0.5f) {
            this.brokenByAnything(serverLevel, source);
            this.remove(Entity.RemovalReason.KILLED);
        } else {
            this.setHealth(f);
        }
    }

    private void breakPlayerStatue(ServerLevel serverLevel, DamageSource source) {
        ResolvableProfile resolvableProfile;
        ItemStack stack = new ItemStack((ItemLike)StatueRegistry.PLAYER_STATUE.get());
        if (this.getGameProfile().isPresent() && (resolvableProfile = this.getGameProfile().get()) != null) {
            stack.set(DataComponents.PROFILE, (Object)resolvableProfile);
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)resolvableProfile.gameProfile().getName()));
        }
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)stack);
        Block.popResource((Level)this.level(), (BlockPos)this.blockPosition(), (ItemStack)new ItemStack((ItemLike)StatueRegistry.STATUE_CORE.get()));
        this.brokenByAnything(serverLevel, source);
    }

    private void brokenByAnything(ServerLevel serverLevel, DamageSource source) {
        this.playBrokenSound();
        this.dropAllDeathLoot(serverLevel, source);
        for (int i = 0; i < this.handItems.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.handItems.get(i);
            if (itemstack.isEmpty()) continue;
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)itemstack);
            this.handItems.set(i, (Object)ItemStack.EMPTY);
        }
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)this.armorItems.get(j);
            if (itemstack1.isEmpty()) continue;
            Block.popResource((Level)this.level(), (BlockPos)this.blockPosition().above(), (ItemStack)itemstack1);
            this.armorItems.set(j, (Object)ItemStack.EMPTY);
        }
    }

    private void playBrokenSound() {
        this.level().playSound((Player)null, this.getX(), this.getY(), this.getZ(), SoundEvents.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    protected float tickHeadTurn(float p_110146_1_, float p_110146_2_) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
        return 0.0f;
    }

    protected float getStandingEdyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.height() * (this.isBaby() ? 0.5f : 0.9f);
    }

    public void travel(Vec3 travelVector) {
        if (this.hasPhysics()) {
            super.travel(travelVector);
        }
    }

    public void setYBodyRot(float offset) {
        this.yBodyRotO = this.yRotO = offset;
        this.yHeadRotO = this.yHeadRot = offset;
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.RIGHT;
    }

    public void setYHeadRot(float rotation) {
        this.yBodyRotO = this.yRotO = rotation;
        this.yHeadRotO = this.yHeadRot = rotation;
    }

    public void tick() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        ResolvableProfile resolvableProfile;
        super.tick();
        if (this.level().isClientSide && this.getGameProfile().isPresent() && (resolvableProfile = this.getGameProfile().get()).id().isPresent() && ClientHandler.TRANSLATORS.contains(resolvableProfile.id().get())) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.getX(), this.getEyeY() + 1.0, this.getZ(), (double)((float)((double)this.level().random.nextFloat() - 0.5) * 3.0f + this.random.nextFloat()) - 0.5, (double)((float)((double)this.level().random.nextFloat() - 0.5) * 3.0f - this.random.nextFloat() - 1.0f), (double)((float)((double)this.level().random.nextFloat() - 0.5) * 3.0f + this.random.nextFloat()) - 0.5);
        }
        if (this.clientLock > 0) {
            --this.clientLock;
            return;
        }
        Rotations rotations = (Rotations)this.entityData.get(HEAD_ROTATION);
        if (!this.headRotation.equals((Object)rotations)) {
            this.setHeadRotation(rotations);
        }
        if (!this.bodyRotation.equals((Object)(rotations1 = (Rotations)this.entityData.get(BODY_ROTATION)))) {
            this.setBodyRotation(rotations1);
        }
        if (!this.leftArmRotation.equals((Object)(rotations2 = (Rotations)this.entityData.get(LEFT_ARM_ROTATION)))) {
            this.setLeftArmRotation(rotations2);
        }
        if (!this.rightArmRotation.equals((Object)(rotations3 = (Rotations)this.entityData.get(RIGHT_ARM_ROTATION)))) {
            this.setRightArmRotation(rotations3);
        }
        if (!this.leftLegRotation.equals((Object)(rotations4 = (Rotations)this.entityData.get(LEFT_LEG_ROTATION)))) {
            this.setLeftLegRotation(rotations4);
        }
        if (!this.rightLegRotation.equals((Object)(rotations5 = (Rotations)this.entityData.get(RIGHT_LEG_ROTATION)))) {
            this.setRightLegRotation(rotations5);
        }
    }

    public boolean isBaby() {
        return this.isSmall();
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
    }

    private void setSmall(boolean small) {
        this.entityData.set(STATUS, (Object)this.setBit((Byte)this.entityData.get(STATUS), 1, small));
    }

    public boolean isSmall() {
        return ((Byte)this.entityData.get(STATUS) & 1) != 0;
    }

    private byte setBit(byte p_184797_1_, int p_184797_2_, boolean p_184797_3_) {
        p_184797_1_ = p_184797_3_ ? (byte)(p_184797_1_ | p_184797_2_) : (byte)(p_184797_1_ & ~p_184797_2_);
        return p_184797_1_;
    }

    public void setHeadRotation(Rotations vec) {
        this.headRotation = vec;
        this.entityData.set(HEAD_ROTATION, (Object)vec);
    }

    public void setBodyRotation(Rotations vec) {
        this.bodyRotation = vec;
        this.entityData.set(BODY_ROTATION, (Object)vec);
    }

    public void setLeftArmRotation(Rotations vec) {
        this.leftArmRotation = vec;
        this.entityData.set(LEFT_ARM_ROTATION, (Object)vec);
    }

    public void setRightArmRotation(Rotations vec) {
        this.rightArmRotation = vec;
        this.entityData.set(RIGHT_ARM_ROTATION, (Object)vec);
    }

    public void setLeftLegRotation(Rotations vec) {
        this.leftLegRotation = vec;
        this.entityData.set(LEFT_LEG_ROTATION, (Object)vec);
    }

    public void setRightLegRotation(Rotations vec) {
        this.rightLegRotation = vec;
        this.entityData.set(RIGHT_LEG_ROTATION, (Object)vec);
    }

    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftLegRotation() {
        return this.leftLegRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightLegRotation() {
        return this.rightLegRotation;
    }

    public boolean isPickable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity entityIn) {
        return entityIn instanceof Player && !this.level().mayInteract((Player)entityIn, this.blockPosition());
    }

    protected SoundEvent getFallDamageSound(int heightIn) {
        return SoundEvents.ARMOR_STAND_FALL;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return SoundEvents.ARMOR_STAND_HIT;
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return SoundEvents.ARMOR_STAND_BREAK;
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt bolt) {
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (STATUS.equals(key)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isRemoved();
        }
        super.onSyncedDataUpdated(key);
    }

    public boolean attackable() {
        return false;
    }
}

