/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datacomponent;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;

public record StatueUpgrades(Map<String, Short> upgradeMap) {
    public static final StatueUpgrades EMPTY = new StatueUpgrades(new HashMap<String, Short>());
    public static final Codec<StatueUpgrades> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.SHORT).xmap(StatueUpgrades::new, StatueUpgrades::upgradeMap);
    public static final StreamCodec<RegistryFriendlyByteBuf, StatueUpgrades> STREAM_CODEC = StreamCodec.of(StatueUpgrades::toNetwork, StatueUpgrades::fromNetwork);

    public static StatueUpgrades empty() {
        return new StatueUpgrades(Map.of());
    }

    private static StatueUpgrades fromNetwork(RegistryFriendlyByteBuf byteBuf) {
        return new StatueUpgrades(byteBuf.readMap(FriendlyByteBuf::readUtf, FriendlyByteBuf::readShort));
    }

    private static void toNetwork(RegistryFriendlyByteBuf byteBuf, StatueUpgrades playerCompassData) {
        Map<String, Short> upgrades = playerCompassData.upgradeMap();
        byteBuf.writeVarInt(upgrades.size());
        upgrades.forEach((string, level) -> {
            byteBuf.writeUtf(string);
            byteBuf.writeShort((int)level.shortValue());
        });
    }

    public Map<String, Short> withUpgrade(String id) {
        HashMap<String, Short> newMap = new HashMap<String, Short>(this.upgradeMap);
        short level = newMap.getOrDefault(id, (short)0);
        newMap.put(id, (short)(level + 1));
        return newMap;
    }

    public Map<String, Short> withDowngrade(String id) {
        HashMap<String, Short> newMap = new HashMap<String, Short>(this.upgradeMap);
        short level = newMap.getOrDefault(id, (short)0);
        if (level > 0) {
            newMap.put(id, (short)(level - 1));
        }
        return newMap;
    }

    public int getUpgradeLevel(String id) {
        return this.upgradeMap == null ? -1 : (int)this.upgradeMap.getOrDefault(id, (short)0).shortValue();
    }

    public MutableComponent getUpgradeName(String id, int level) {
        String descriptionID = "statues.upgrade." + id + ".name";
        MutableComponent mutablecomponent = Component.translatable((String)descriptionID).withStyle(ChatFormatting.GRAY);
        if (level > 0) {
            mutablecomponent.append(" ").append((Component)Component.translatable((String)("enchantment.level." + level)));
        }
        return mutablecomponent;
    }

    public List<Component> getUpgradeNames() {
        ArrayList<Component> components = new ArrayList<Component>();
        for (Map.Entry<String, Short> entry : this.upgradeMap.entrySet()) {
            components.add((Component)this.getUpgradeName(entry.getKey(), entry.getValue().shortValue()));
        }
        return components;
    }
}

