/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datacomponent;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public final class StatueStats {
    public static final Codec<StatueStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.optionalFieldOf("level", (Object)0).forGetter(StatueStats::level), (App)Codec.INT.optionalFieldOf("killCount", (Object)0).forGetter(StatueStats::killCount), (App)Codec.INT.optionalFieldOf("upgradeSlots", (Object)0).forGetter(StatueStats::upgradeSlots)).apply((Applicative)inst, StatueStats::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StatueStats> STREAM_CODEC = StreamCodec.of(StatueStats::toNetwork, StatueStats::fromNetwork);
    private int level;
    private int killCount;
    private int upgradeSlots;

    public StatueStats(int level, int killCount, int upgradeSlots) {
        this.level = level;
        this.killCount = killCount;
        this.upgradeSlots = upgradeSlots;
    }

    public static StatueStats empty() {
        return new StatueStats(0, 0, 0);
    }

    private static StatueStats fromNetwork(RegistryFriendlyByteBuf byteBuf) {
        int level = byteBuf.readInt();
        int killCount = byteBuf.readInt();
        int upgradeSlots = byteBuf.readInt();
        return new StatueStats(level, killCount, upgradeSlots);
    }

    private static void toNetwork(RegistryFriendlyByteBuf byteBuf, StatueStats playerCompassData) {
        byteBuf.writeInt(playerCompassData.level());
        byteBuf.writeInt(playerCompassData.killCount());
        byteBuf.writeInt(playerCompassData.upgradeSlots());
    }

    public int level() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int killCount() {
        return this.killCount;
    }

    public void setKillCount(int killCount) {
        this.killCount = killCount;
    }

    public int upgradeSlots() {
        return this.upgradeSlots;
    }

    public void setUpgradeSlots(int upgradeSlots) {
        this.upgradeSlots = upgradeSlots;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        StatueStats that = (StatueStats)obj;
        return this.level == that.level && this.killCount == that.killCount && this.upgradeSlots == that.upgradeSlots;
    }

    public int hashCode() {
        return Objects.hash(this.level, this.killCount, this.upgradeSlots);
    }

    public String toString() {
        return "StatueStats[level=" + this.level + ", killCount=" + this.killCount + ", upgradeSlots=" + this.upgradeSlots + "]";
    }
}

