/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.rei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.shynieke.statues.compat.rei.REIPlugin;
import com.shynieke.statues.compat.rei.display.UpgradeDisplay;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class UpgradeCategory
implements DisplayCategory<UpgradeDisplay> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"statues", (String)"textures/gui/jei/upgrade.png");

    public CategoryIdentifier<? extends UpgradeDisplay> getCategoryIdentifier() {
        return REIPlugin.UPGRADE;
    }

    public Component getTitle() {
        return Component.translatable((String)"statues.gui.jei.category.upgrade");
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)StatueRegistry.STATUE_TABLE.get()));
    }

    public List<Widget> setupDisplay(UpgradeDisplay display, Rectangle bounds) {
        Point centerPoint = new Point(bounds.getCenterX(), bounds.getCenterY());
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createRecipeBase((Rectangle)bounds));
        if (display.isRequireCore()) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getMinX() + 9, bounds.getMaxY() - 24)).entries((Collection)display.getCore()).markInput());
        } else {
            widgets.add(Widgets.createTexturedWidget((ResourceLocation)TEXTURE, (int)(bounds.getMinX() + 8), (int)(bounds.getMaxY() - 25), (float)0.0f, (float)40.0f, (int)18, (int)18));
        }
        widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x, centerPoint.y - 7)).entries((Collection)display.getCenter()).markInput());
        widgets.add(Widgets.createSlotBackground((Point)new Point(centerPoint.x - 18, centerPoint.y - 25)));
        widgets.add(Widgets.createSlotBackground((Point)new Point(centerPoint.x + 18, centerPoint.y - 25)));
        widgets.add(Widgets.createSlotBackground((Point)new Point(centerPoint.x - 18, centerPoint.y + 11)));
        widgets.add(Widgets.createSlotBackground((Point)new Point(centerPoint.x + 18, centerPoint.y + 11)));
        List<EntryIngredient> catalysts = display.getCatalysts();
        if (!catalysts.isEmpty()) {
            widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x - 18, centerPoint.y - 25)).entries((Collection)catalysts.get(0)).disableBackground().markInput());
            if (catalysts.size() > 1) {
                widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x + 18, centerPoint.y - 25)).entries((Collection)catalysts.get(1)).disableBackground().markInput());
                if (catalysts.size() > 2) {
                    widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x - 18, centerPoint.y + 11)).entries((Collection)catalysts.get(2)).disableBackground().markInput());
                    if (catalysts.size() > 3) {
                        widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x + 18, centerPoint.y + 11)).entries((Collection)catalysts.get(3)).disableBackground().markInput());
                    }
                }
            }
        }
        widgets.add((Widget)Widgets.createSlot((Point)new Point(centerPoint.x + 46, centerPoint.y - 7)).entries((Collection)display.getResult()).markOutput());
        widgets.add((Widget)Widgets.withTranslate((Widget)Widgets.createDrawableWidget((guiGraphics, mouseX, mouseY, v) -> {
            PoseStack poseStack = guiGraphics.pose();
            poseStack.pushPose();
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, (Component)this.getUpgradeName(display.getUpgradeType().getSerializedName(), display.getTier() + 1).withStyle(ChatFormatting.DARK_GRAY), 3, 25, 0, false);
            poseStack.popPose();
        }), (double)(bounds.x + 3), (double)(bounds.y + 3), (double)0.0));
        return widgets;
    }

    private MutableComponent getUpgradeName(String id, int level) {
        String descriptionID = "statues.upgrade." + id + ".name";
        MutableComponent mutablecomponent = Component.translatable((String)descriptionID).withStyle(ChatFormatting.GRAY);
        if (level > 0) {
            mutablecomponent.append(" ").append((Component)Component.translatable((String)("enchantment.level." + level)));
        }
        return mutablecomponent;
    }

    public int getDisplayWidth(UpgradeDisplay display) {
        return 148;
    }
}

