/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.compat.jei.category;

import com.shynieke.statues.compat.jei.JEIPlugin;
import com.shynieke.statues.recipe.LootRecipe;
import com.shynieke.statues.registry.StatueRegistry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class LootCategory
implements IRecipeCategory<LootRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;

    public LootCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(JEIPlugin.LOOT_BACKGROUND, 0, 0, 100, 62);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)StatueRegistry.STATUE_TABLE.get()));
        this.localizedName = Component.translatable((String)"statues.gui.jei.category.loot");
    }

    public RecipeType<LootRecipe> getRecipeType() {
        return JEIPlugin.LOOT_TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LootRecipe recipe, IFocusGroup focuses) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        if (level == null) {
            throw new NullPointerException("level must not be null.");
        }
        RegistryAccess registryAccess = level.registryAccess();
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 23).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 5).addItemStack(recipe.getResultItem((HolderLookup.Provider)registryAccess));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 23).addItemStack(recipe.getResultItem2((HolderLookup.Provider)registryAccess));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 41).addItemStack(recipe.getResultItem3(registryAccess));
    }

    public void draw(LootRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        guiGraphics.drawString(font, (Component)Component.literal((String)((int)(100.0f * recipe.getChance1()) + "%")), 74, 8, 0, false);
        guiGraphics.drawString(font, (Component)Component.literal((String)((int)(100.0f * recipe.getChance2()) + "%")), 74, 27, 0, false);
        guiGraphics.drawString(font, (Component)Component.literal((String)((int)(100.0f * recipe.getChance3()) + "%")), 74, 45, 0, false);
    }

    public Component getTitle() {
        return this.localizedName;
    }
}

