/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.shynieke.statues.commands.StatuesDevCommands;
import com.shynieke.statues.datacomponent.StatueStats;
import com.shynieke.statues.recipe.UpgradeType;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueTags;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.server.command.EnumArgument;

public class StatuesCommands {
    public static void initializeCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"statues");
        List upgrades = Arrays.stream(UpgradeType.values()).filter(value -> value != UpgradeType.CRAFTING).map(Enum::name).collect(Collectors.toList());
        ((LiteralArgumentBuilder)root.requires(source -> source.hasPermission(2))).then(Commands.literal((String)"upgrade").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"upgrade", (ArgumentType)EnumArgument.enumArgument(UpgradeType.class)).suggests((cs, builder) -> SharedSuggestionProvider.suggest((Iterable)upgrades, (SuggestionsBuilder)builder)).then(Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(StatuesCommands::upgradeStatue)))));
        if (!FMLLoader.isProduction()) {
            ((LiteralArgumentBuilder)root.requires(source -> source.hasPermission(2))).then(Commands.literal((String)"checkLoot").executes(StatuesDevCommands::checkLoot));
            ((LiteralArgumentBuilder)root.requires(source -> source.hasPermission(2))).then(Commands.literal((String)"checkBlockEntity").executes(StatuesDevCommands::checkBlockEntity));
        }
        dispatcher.register(root);
    }

    private static int upgradeStatue(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        UpgradeType upgrade = (UpgradeType)((Object)ctx.getArgument("upgrade", UpgradeType.class));
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        int tier = (Integer)ctx.getArgument("tier", Integer.class);
        if (tier > upgrade.getCap()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"commands.statues.upgrade.too_high", (Object[])new Object[]{upgrade.getCap()}).withStyle(ChatFormatting.RED));
            return 0;
        }
        ItemStack heldStack = player.getMainHandItem();
        if (!heldStack.isEmpty() && heldStack.is(StatueTags.UPGRADEABLE_STATUES)) {
            if (heldStack.has(StatueDataComponents.UPGRADED) || ((StatueStats)heldStack.getOrDefault(StatueDataComponents.STATS, (Object)StatueStats.empty())).upgradeSlots() < 1) {
                StatuesCommands.fillInTag(heldStack, tier);
            }
            for (int i = 0; i < tier; ++i) {
                upgrade.apply(heldStack, i);
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.translatable((String)"commands.statues.upgrade.success", (Object[])new Object[]{I18n.get((String)heldStack.getDescriptionId(), (Object[])new Object[0])}).withStyle(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.translatable((String)"commands.statues.upgrade.invalid", (Object[])new Object[]{I18n.get((String)heldStack.getDescriptionId(), (Object[])new Object[0])}).withStyle(ChatFormatting.RED));
        }
        return 0;
    }

    private static void fillInTag(ItemStack stack, int tier) {
        stack.set(StatueDataComponents.UPGRADED.get(), (Object)true);
        StatueStats stats = (StatueStats)stack.getOrDefault(StatueDataComponents.STATS.get(), (Object)StatueStats.empty());
        stats.setLevel(tier == -1 ? 0 : tier + 1);
        stats.setUpgradeSlots(20);
        stack.set(StatueDataComponents.STATS.get(), (Object)stats);
    }
}

