/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class PlayerStatueData {
    public boolean small = false;
    public boolean locked = false;
    public boolean nameVisible = true;
    public boolean noGravity = false;
    public float yOffset = 0.0f;
    public float rotation = 0.0f;
    public String modelType = "AUTO";
    public final float[] pose = new float[21];

    public boolean isSmall() {
        return this.small;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean getNameVisible() {
        return this.nameVisible;
    }

    public boolean hasNoGravity() {
        return this.noGravity;
    }

    public void readFromNBT(CompoundTag compound) {
        this.small = compound.getBoolean("Small");
        this.locked = compound.getBoolean("Locked");
        this.nameVisible = compound.getBoolean("CustomNameVisible");
        this.noGravity = compound.getBoolean("NoGravity");
        this.yOffset = compound.getFloat("yOffset");
        this.modelType = compound.getString("Model");
        if (compound.contains("Rotation")) {
            this.rotation = compound.getList("Rotation", 5).getFloat(0);
        }
        if (compound.contains("Pose")) {
            CompoundTag poseTag = (CompoundTag)compound.get("Pose");
            String[] keys = new String[]{"Head", "Body", "LeftLeg", "RightLeg", "LeftArm", "RightArm"};
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (!poseTag.contains(key)) continue;
                ListTag tagList = poseTag.getList(key, 5);
                for (int j = 0; j <= 2; ++j) {
                    int k = i * 3 + j;
                    this.pose[k] = tagList.getFloat(j);
                }
            }
        }
    }

    public CompoundTag writeToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Small", this.small);
        compound.putBoolean("Locked", this.locked);
        compound.putBoolean("CustomNameVisible", this.nameVisible);
        compound.putBoolean("NoGravity", this.noGravity);
        compound.putFloat("yOffset", this.yOffset);
        compound.putString("Model", this.modelType);
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.valueOf((float)this.rotation));
        compound.put("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[0]));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[1]));
        poseHeadTag.add((Object)FloatTag.valueOf((float)this.pose[2]));
        poseTag.put("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[3]));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[4]));
        poseBodyTag.add((Object)FloatTag.valueOf((float)this.pose[5]));
        poseTag.put("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[6]));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[7]));
        poseLeftLegTag.add((Object)FloatTag.valueOf((float)this.pose[8]));
        poseTag.put("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[9]));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[10]));
        poseRightLegTag.add((Object)FloatTag.valueOf((float)this.pose[11]));
        poseTag.put("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[12]));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[13]));
        poseLeftArmTag.add((Object)FloatTag.valueOf((float)this.pose[14]));
        poseTag.put("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[15]));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[16]));
        poseRightArmTag.add((Object)FloatTag.valueOf((float)this.pose[17]));
        poseTag.put("RightArm", (Tag)poseRightArmTag);
        compound.put("Pose", (Tag)poseTag);
        return compound;
    }

    public static enum MODEL_TYPE {
        AUTO,
        DEFAULT,
        SLIM;

    }
}

