/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.shynieke.statues.Statues;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.client.model.StatuePlayerTileModel;
import com.shynieke.statues.client.render.PlayerBER;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;

public class PlayerBEWLR
extends BlockEntityWithoutLevelRenderer {
    private final StatuePlayerTileModel model;
    private final StatuePlayerTileModel slimModel;
    public boolean isSlim = false;
    private static final Map<String, ResolvableProfile> GAMEPROFILE_CACHE = new HashMap<String, ResolvableProfile>();

    public PlayerBEWLR(BlockEntityRendererProvider.Context context) {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
        this.model = new StatuePlayerTileModel(context.bakeLayer(ClientHandler.PLAYER_STATUE), false);
        this.slimModel = new StatuePlayerTileModel(context.bakeLayer(ClientHandler.PLAYER_STATUE_SLIM), false);
    }

    public void renderByItem(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        this.renderPlayerItem(stack, poseStack, bufferSource, combinedLight);
    }

    public void renderPlayerItem(ItemStack stack, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        poseStack.pushPose();
        if (stack != null) {
            ResolvableProfile gameprofile = null;
            if (stack.has(DataComponents.CUSTOM_NAME)) {
                boolean validFlag;
                String stackName = stack.getHoverName().getString().toLowerCase(Locale.ROOT);
                boolean bl = validFlag = !stackName.isEmpty() && !stackName.contains(" ");
                if (validFlag) {
                    ResolvableProfile resolvableProfile;
                    if (GAMEPROFILE_CACHE.containsKey(stackName)) {
                        gameprofile = GAMEPROFILE_CACHE.get(stackName);
                    }
                    if (!stack.has(DataComponents.PROFILE)) {
                        stack.set(DataComponents.PROFILE, (Object)gameprofile);
                    }
                    if (stack.has(DataComponents.PROFILE) && gameprofile == null && (resolvableProfile = (ResolvableProfile)stack.get(DataComponents.PROFILE)) != null && !resolvableProfile.isResolved()) {
                        stack.remove(DataComponents.PROFILE);
                        PlayerBlockEntity.resolve(resolvableProfile).thenAcceptAsync(profile -> stack.set(DataComponents.PROFILE, profile), (Executor)Minecraft.getInstance());
                    }
                    if (gameprofile == null) {
                        PlayerBlockEntity.fetchGameProfile(stackName).thenAccept(profile -> {
                            if (profile.isPresent()) {
                                GameProfile profile1 = profile.orElse(new GameProfile(Util.NIL_UUID, stackName));
                                ResolvableProfile resolvableProfile = new ResolvableProfile(profile1);
                                stack.set(DataComponents.PROFILE, (Object)resolvableProfile);
                                GAMEPROFILE_CACHE.put(profile1.getName().toLowerCase(), resolvableProfile);
                            }
                        });
                    }
                } else {
                    if (GAMEPROFILE_CACHE.containsKey("steve")) {
                        gameprofile = GAMEPROFILE_CACHE.get("steve");
                    }
                    if (gameprofile == null) {
                        Statues.LOGGER.error("Could not find profile for {}, defaulting to steve!", (Object)stackName);
                        PlayerBlockEntity.fetchGameProfile("steve").thenAccept(profile -> {
                            if (profile.isPresent()) {
                                GameProfile profile1 = profile.orElse(new GameProfile(Util.NIL_UUID, "steve"));
                                GAMEPROFILE_CACHE.put(profile1.getName().toLowerCase(), new ResolvableProfile(profile1));
                            }
                        });
                    }
                }
            }
            poseStack.translate(0.5, 1.4, 0.5);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            this.renderItem(gameprofile, poseStack, bufferSource, combinedLight);
        }
        poseStack.popPose();
    }

    public void renderItem(ResolvableProfile resolvableProfile, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        int light;
        SkinManager skinmanager = Minecraft.getInstance().getSkinManager();
        if (resolvableProfile != null && this.isSlim != skinmanager.getInsecureSkin(resolvableProfile.gameProfile()).model().id().equals("slim")) {
            this.isSlim = !this.isSlim;
        }
        VertexConsumer vertexConsumer = bufferSource.getBuffer(PlayerBER.getRenderType(resolvableProfile));
        boolean isSupporter = false;
        if (resolvableProfile != null) {
            String s = ChatFormatting.stripFormatting((String)resolvableProfile.name().orElse("Steve"));
            if ("Dinnerbone".equalsIgnoreCase(s) || "Grumm".equalsIgnoreCase(s)) {
                poseStack.translate(0.0, 1.85, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            }
            isSupporter = ClientHandler.SUPPORTER.contains(resolvableProfile.id().orElse(Util.NIL_UUID));
        }
        int n = light = isSupporter ? 0xF000F0 : combinedLight;
        if (this.isSlim) {
            if (this.slimModel != null) {
                this.slimModel.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
            }
        } else if (this.model != null) {
            this.model.renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        }
    }
}

