/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues.fish;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blockentities.TropicalFishBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueTags;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FishStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    private static final VoxelShape SHAPE_BIG = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private final int size;

    public FishStatueBlock(BlockBehaviour.Properties builder, int size) {
        super(builder.sound(SoundType.STONE));
        this.size = size;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.size == 1) {
            return SHAPE_BIG;
        }
        return SHAPE;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        if (state.is(StatueTags.IS_TROPICAL_FISH) && stack.getItem() == Items.WET_SPONGE) {
            TropicalFishBlockEntity fishBlockEntity = this.getFishTE((BlockGetter)level, pos);
            fishBlockEntity.scrambleColors();
            level.sendBlockUpdated(pos, state, state, 6);
            level.playSound(null, pos, SoundEvents.SLIME_SQUISH_SMALL, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!player.hasInfiniteMaterials()) {
                stack.shrink(1);
                if (!player.getInventory().add(new ItemStack((ItemLike)Items.SPONGE))) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), stack);
                    level.addFreshEntity((Entity)itemEntity);
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, handIn, result);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (state.is(StatueTags.IS_TROPICAL_FISH)) {
            return new TropicalFishBlockEntity(pos, state);
        }
        return super.newBlockEntity(pos, state);
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.TROPICAL_FISH;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.TROPICAL_FISH_FLOP;
    }

    public TropicalFishBlockEntity getFishTE(BlockGetter getter, BlockPos pos) {
        return getter.getBlockEntity(pos) instanceof TropicalFishBlockEntity ? (TropicalFishBlockEntity)getter.getBlockEntity(pos) : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TropicalFishBlockEntity fishBlockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (state.is(StatueTags.IS_TROPICAL_FISH) && (fishBlockEntity = this.getFishTE((BlockGetter)level, pos)) != null) {
            fishBlockEntity.scrambleColors();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(BlockState state, BlockGetter getter, BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (pos != null && (blockEntity = getter.getBlockEntity(pos)) instanceof TropicalFishBlockEntity) {
            TropicalFishBlockEntity tropicalFishBlockEntity = (TropicalFishBlockEntity)blockEntity;
            return tintIndex == 1 ? FishStatueBlock.fromColor(tropicalFishBlockEntity.getMainColor()) : (tintIndex == 2 ? FishStatueBlock.fromColor(tropicalFishBlockEntity.getSecondaryColor()) : -1);
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int fromColor(int color) {
        return DyeColor.byId((int)color).getTextColor();
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (state.is(StatueTags.IS_TROPICAL_FISH)) {
            if (((Boolean)state.getValue((Property)INTERACTIVE)).booleanValue()) {
                return FishStatueBlock.createStatueTicker(level, blockEntityType, StatueBlockEntities.TROPICAL_FISH.get());
            }
            return null;
        }
        return super.getTicker(level, state, blockEntityType);
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createStatueTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends StatueBlockEntity> blockEntityType1) {
        return level.isClientSide ? null : FishStatueBlock.createTickerHelper(blockEntityType, blockEntityType1, StatueBlockEntity::serverTick);
    }
}

