/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blocks.AbstractStatueBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PandaStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SOUTH_EAST_SHAPE = Block.box((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)11.0, (double)15.0);
    private static final VoxelShape NORTH_WEST_SHAPE = Block.box((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)11.0, (double)12.0);

    public PandaStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.sound(SoundType.STONE));
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.PANDA;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.PANDA_AMBIENT;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return direction.getAxis() == Direction.Axis.X ? NORTH_WEST_SHAPE : SOUTH_EAST_SHAPE;
    }
}

