/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.KingCluckStatueBlock;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ChickenStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);

    public ChickenStatueBlock(BlockBehaviour.Properties builder) {
        super(builder.sound(SoundType.STONE));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (this.isDecorative(state) && placer != null && level.getBlockState(pos.below()).is(Blocks.GOLD_BLOCK)) {
            BlockPos downPos = pos.below();
            level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)downPos.getX(), (double)downPos.getY(), (double)downPos.getZ(), 1.0, 0.0, 0.0);
            BlockState kingState = (BlockState)((KingCluckStatueBlock)((Object)StatueRegistry.KING_CLUCK_STATUE.get())).defaultBlockState().setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite());
            level.setBlockAndUpdate(pos.below(), kingState);
            level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            StatueBlockEntity newBlockEntity = new StatueBlockEntity(pos.below(), kingState);
            level.setBlockEntity((BlockEntity)newBlockEntity);
        }
        super.setPlacedBy(level, pos, state, placer, stack);
    }

    public boolean isDecorative(BlockState state) {
        return (Boolean)state.getValue((Property)INTERACTIVE) == false;
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.CHICKEN;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.CHICKEN_AMBIENT;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

