/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.decorative;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class DisplayStandBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)4.0, (double)15.0), Block.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0), Block.box((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.box((double)0.0, (double)15.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0), Block.box((double)14.0, (double)15.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)15.0, (double)2.0, (double)14.0, (double)16.0, (double)4.0), Block.box((double)2.0, (double)15.0, (double)12.0, (double)14.0, (double)16.0, (double)14.0), Block.box((double)2.0, (double)15.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0), Block.box((double)12.0, (double)15.0, (double)4.0, (double)14.0, (double)16.0, (double)12.0), Block.box((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)5.0), Block.box((double)4.0, (double)15.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0), Block.box((double)4.0, (double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0), Block.box((double)11.0, (double)15.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0), Block.box((double)5.0, (double)15.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public DisplayStandBlock(BlockBehaviour.Properties properties) {
        super(properties.isRedstoneConductor(DisplayStandBlock::isntSolid));
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    private static boolean isntSolid(BlockState state, BlockGetter getter, BlockPos pos) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        FluidState fluidstate = context.getLevel().getFluidState(blockpos);
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }
}

