/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.blocks.AbstractBaseBlock;
import com.shynieke.statues.registry.StatueBlockEntities;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStatueBase
extends AbstractBaseBlock
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final BooleanProperty INTERACTIVE = BooleanProperty.create((String)"interactive");

    public AbstractStatueBase(BlockBehaviour.Properties builder) {
        super(builder.strength(0.6f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)INTERACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (!level.isClientSide && this.canPlaySound(level, pos, state)) {
            level.playSound(null, pos, this.getSound(state), SoundSource.NEUTRAL, 1.0f, this.getPitch());
        }
        return super.useWithoutItem(state, level, pos, player, result);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (((Boolean)state.getValue((Property)INTERACTIVE)).booleanValue() && hand == InteractionHand.MAIN_HAND && !level.isClientSide && this.getBE((BlockGetter)level, pos) != null) {
            return this.getBE((BlockGetter)level, pos).interact(level, pos, state, player, hand, result);
        }
        return ItemInteractionResult.SUCCESS;
    }

    public StatueBlockEntity getBE(BlockGetter getter, BlockPos pos) {
        BlockEntity blockEntity = getter.getBlockEntity(pos);
        if (blockEntity instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            return statueBlockEntity;
        }
        return null;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        StatueBlockEntity statueBlockEntity = this.getBE(level, pos);
        if (statueBlockEntity != null && statueBlockEntity.getUpgradeLevel("glowing") > 0) {
            return statueBlockEntity.getUpgradeLevel("glowing");
        }
        return super.getLightEmission(state, level, pos);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StatueBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (((Boolean)state.getValue((Property)INTERACTIVE)).booleanValue()) {
            return AbstractStatueBase.createStatueTicker(level, blockEntityType, StatueBlockEntities.STATUE.get());
        }
        return null;
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createStatueTicker(Level level, BlockEntityType<T> blockEntityType, BlockEntityType<? extends StatueBlockEntity> blockEntityType1) {
        return level.isClientSide ? null : AbstractStatueBase.createTickerHelper(blockEntityType, blockEntityType1, StatueBlockEntity::serverTick);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.getCloneItemStack(level, pos, state);
        if (level.getBlockEntity(pos) != null) {
            level.getBlockEntity(pos).saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
        }
        return itemstack;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)INTERACTIVE)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (!level.isClientSide && !player.hasInfiniteMaterials()) {
                ItemStack itemstack = new ItemStack((ItemLike)this.asItem());
                statueBlockEntity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
                blockentity.saveToItem(itemstack, (HolderLookup.Provider)level.registryAccess());
                ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, itemstack);
                itementity.setDefaultPickUpDelay();
                level.addFreshEntity((Entity)itementity);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        if (((Boolean)state.getValue((Property)INTERACTIVE)).booleanValue()) {
            return new ArrayList<ItemStack>();
        }
        return super.getDrops(state, builder);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, INTERACTIVE});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return true;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, level, pos, newState, isMoving);
            level.removeBlockEntity(pos);
        }
    }

    public boolean isHiddenStatue() {
        return false;
    }

    public boolean isBaby() {
        return false;
    }

    public EntityType<?> getEntity() {
        return EntityType.EGG;
    }

    public LivingEntity adjustSpawnedEntity(LivingEntity livingEntity) {
        return livingEntity;
    }

    public SoundEvent getSound(BlockState state) {
        return SoundEvents.ANVIL_LAND;
    }

    public float getPitch() {
        return this.isBaby() ? (RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.2f + 1.5f : (RANDOM.nextFloat() - RANDOM.nextFloat()) * 0.2f + 1.0f;
    }

    public boolean canPlaySound(Level level, BlockPos pos, BlockState state) {
        StatueBlockEntity statueBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        boolean flag = (Boolean)state.getValue((Property)INTERACTIVE) != false && blockEntity instanceof StatueBlockEntity && (statueBlockEntity = (StatueBlockEntity)blockEntity).makesSounds();
        boolean flag2 = level.getBlockState(pos.below()).getBlock() instanceof NoteBlock;
        return flag || flag2;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.isClientSide && this.canPlaySound(level, pos, state) && level.hasNeighborSignal(pos)) {
            level.playSound(null, pos, this.getSound(state), SoundSource.NEUTRAL, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.2f + 1.5f);
        }
        super.neighborChanged(state, level, pos, blockIn, fromPos, isMoving);
    }
}

