/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.commands.StatuesCommands;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.handlers.DropHandler;
import com.shynieke.statues.handlers.FishHandler;
import com.shynieke.statues.handlers.SpecialHandler;
import com.shynieke.statues.handlers.StatueHandler;
import com.shynieke.statues.handlers.TraderHandler;
import com.shynieke.statues.network.StatuesNetworking;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.registry.StatueBlockEntities;
import com.shynieke.statues.registry.StatueDataComponents;
import com.shynieke.statues.registry.StatueEntities;
import com.shynieke.statues.registry.StatueLootModifiers;
import com.shynieke.statues.registry.StatuePatterns;
import com.shynieke.statues.registry.StatueRegistry;
import com.shynieke.statues.registry.StatueSerializers;
import com.shynieke.statues.registry.StatueSounds;
import java.util.concurrent.Executor;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.GameProfileCache;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import org.slf4j.Logger;

@Mod(value="statues")
public class Statues {
    public static final Logger LOGGER = LogUtils.getLogger();

    public Statues(IEventBus eventBus, Dist dist, ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)StatuesConfig.commonSpec);
        eventBus.register(StatuesConfig.class);
        eventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.addListener(this::serverAboutToStart);
        NeoForge.EVENT_BUS.addListener(this::onCommandRegister);
        StatueSerializers.ENTITY_DATA_SERIALIZER.register(eventBus);
        StatueRegistry.ENTITIES.register(eventBus);
        StatueRegistry.BLOCKS.register(eventBus);
        StatueDataComponents.DATA_COMPONENT_TYPES.register(eventBus);
        StatueRegistry.ITEMS.register(eventBus);
        StatueRegistry.CREATIVE_MODE_TABS.register(eventBus);
        StatueRegistry.MENU_TYPES.register(eventBus);
        StatueBlockEntities.BLOCK_ENTITIES.register(eventBus);
        StatueSounds.SOUND_EVENTS.register(eventBus);
        StatuesRecipes.RECIPE_TYPES.register(eventBus);
        StatuesRecipes.RECIPE_SERIALIZERS.register(eventBus);
        StatueLootModifiers.GLM.register(eventBus);
        StatuePatterns.POT_PATTERNS.register(eventBus);
        eventBus.addListener(StatueEntities::registerEntityAttributes);
        eventBus.addListener(StatueEntities::registerSpawnPlacements);
        eventBus.addListener(StatueBlockEntities::registerCapabilities);
        eventBus.addListener(StatuesNetworking::setupPackets);
        NeoForge.EVENT_BUS.register((Object)new StatueHandler());
        NeoForge.EVENT_BUS.register((Object)new FishHandler());
        NeoForge.EVENT_BUS.register((Object)new TraderHandler());
        NeoForge.EVENT_BUS.register((Object)new DropHandler());
        NeoForge.EVENT_BUS.register((Object)new SpecialHandler());
        if (dist.isClient()) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)StatuesConfig.clientSpec);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            eventBus.addListener(ClientHandler::doClientStuff);
            eventBus.addListener(ClientHandler::onRegisterMenu);
            eventBus.addListener(ClientHandler::registerEntityRenders);
            eventBus.addListener(ClientHandler::registerLayerDefinitions);
            eventBus.addListener(ClientHandler::registerBlockColors);
            NeoForge.EVENT_BUS.addListener(ClientHandler::onLogin);
            NeoForge.EVENT_BUS.addListener(ClientHandler::onRespawn);
        }
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> StatuePatterns.expandVanillaDefinitions());
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        StatuesCommands.initializeCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public void serverAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        PlayerBlockEntity.setup(server.services, (Executor)server);
        GameProfileCache.setUsesAuthentication((boolean)server.usesAuthentication());
    }
}

