/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum RedstoneMode implements StringRepresentable
{
    REDSTONE_IGNORED("Ignored"),
    REDSTONE_OFFREQUIRED("Off"),
    REDSTONE_ONREQUIRED("On");

    private static final Map<String, RedstoneMode> modeToMode;
    public static final Codec<RedstoneMode> CODEC;
    public static final StreamCodec<FriendlyByteBuf, RedstoneMode> STREAM_CODEC;
    private final String description;

    private RedstoneMode(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static RedstoneMode getMode(String mode) {
        return modeToMode.get(mode);
    }

    public String getSerializedName() {
        return this.name();
    }

    static {
        modeToMode = new HashMap<String, RedstoneMode>();
        CODEC = StringRepresentable.fromEnum(RedstoneMode::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(RedstoneMode.class);
        for (RedstoneMode mode : RedstoneMode.values()) {
            modeToMode.put(mode.description, mode);
        }
    }
}

