/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.modules.ItemModule;
import mcjty.lib.setup.Registration;
import mcjty.lib.varia.ComponentFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class ModuleTools {
    public static boolean hasModuleTarget(ItemStack stack) {
        return stack.get(Registration.ITEM_MODULE) != null;
    }

    public static void setPositionInModule(ItemStack stack, ResourceKey<Level> dimension, BlockPos pos, String name) {
        stack.set(Registration.ITEM_MODULE, (Object)new ItemModule(GlobalPos.of(dimension, (BlockPos)pos), name));
    }

    public static void clearPositionInModule(ItemStack stack) {
        stack.remove(Registration.ITEM_MODULE);
    }

    @Nonnull
    public static BlockPos getPositionFromModule(ItemStack stack) {
        ItemModule module = (ItemModule)stack.get(Registration.ITEM_MODULE);
        if (module != null) {
            return module.pos().pos();
        }
        return BlockPos.ZERO;
    }

    @Nullable
    public static ResourceKey<Level> getDimensionFromModule(ItemStack stack) {
        ItemModule module = (ItemModule)stack.get(Registration.ITEM_MODULE);
        if (module != null) {
            return module.pos().dimension();
        }
        return null;
    }

    public static String getTargetString(ItemStack stack) {
        ItemModule module = (ItemModule)stack.get(Registration.ITEM_MODULE);
        if (module != null) {
            String name = module.name();
            GlobalPos pos = module.pos();
            return name + " (at " + pos.pos().getX() + "," + pos.pos().getY() + "," + pos.pos().getZ() + ", " + String.valueOf(pos.dimension().location()) + ")";
        }
        return "<unset>";
    }

    public static boolean installModule(Player player, ItemStack heldItem, InteractionHand hand, BlockPos pos, int start, int stop) {
        Level world = player.getCommandSenderWorld();
        BlockEntity te = world.getBlockEntity(pos);
        if (te == null) {
            return false;
        }
        IItemHandler inventory = (IItemHandler)world.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
        if (inventory != null) {
            for (int i = start; i <= stop; ++i) {
                if (!inventory.getStackInSlot(i).isEmpty()) continue;
                ItemStack copy = heldItem.copy();
                copy.setCount(1);
                if (!(inventory instanceof IItemHandlerModifiable)) {
                    throw new IllegalStateException("Not an IItemHandlerModifiable!");
                }
                ((IItemHandlerModifiable)inventory).setStackInSlot(i, copy);
                heldItem.shrink(1);
                if (heldItem.isEmpty()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
                if (world.isClientSide) {
                    player.displayClientMessage((Component)ComponentFactory.literal("Installed module"), false);
                }
                return true;
            }
        }
        return false;
    }
}

