/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.preferences;

import javax.annotation.Nonnull;
import mcjty.lib.gui.BuffStyle;
import mcjty.lib.gui.GuiStyle;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketSendPreferencesToClient;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class PreferencesProperties
implements INBTSerializable<CompoundTag> {
    private static final int DEFAULT_BUFFX = -20;
    private static final int DEFAULT_BUFFY = -20;
    private static final GuiStyle DEFAULT_STYLE = GuiStyle.STYLE_FLAT_GRADIENT;
    private int buffX = -20;
    private int buffY = -20;
    private BuffStyle buffStyle = BuffStyle.BOTRIGHT;
    private GuiStyle style = DEFAULT_STYLE;
    private boolean dirty = true;

    public void tick(ServerPlayer player) {
        if (this.dirty) {
            this.syncToClient(player);
        }
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveNBTData(tag);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        this.loadNBTData(compoundTag);
    }

    private void syncToClient(ServerPlayer player) {
        Networking.sendToPlayer(PacketSendPreferencesToClient.create(this.buffStyle, this.buffX, this.buffY, this.style), (Player)player);
        this.dirty = false;
    }

    public void saveNBTData(CompoundTag compound) {
        compound.putString("buffStyle", this.buffStyle.getName());
        compound.putInt("buffX", this.buffX);
        compound.putInt("buffY", this.buffY);
        compound.putString("style", this.style.getStyle());
    }

    public void loadNBTData(CompoundTag compound) {
        this.buffStyle = BuffStyle.getStyle(compound.getString("buffStyle"));
        if (this.buffStyle == null) {
            this.buffStyle = BuffStyle.BOTRIGHT;
            this.buffX = -20;
            this.buffY = -20;
        } else {
            this.buffX = compound.getInt("buffX");
            this.buffY = compound.getInt("buffY");
        }
        String s = compound.getString("style");
        this.style = GuiStyle.getStyle(s);
        if (this.style == null) {
            this.style = DEFAULT_STYLE;
        }
        this.dirty = true;
    }

    public void reset() {
        this.buffStyle = BuffStyle.TOPLEFT;
        this.buffX = -20;
        this.buffY = -20;
        this.style = DEFAULT_STYLE;
        this.dirty = true;
    }

    public boolean setStyle(String s) {
        GuiStyle st = GuiStyle.getStyle(s);
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    public boolean setStyle(GuiStyle st) {
        if (st == null) {
            return false;
        }
        this.style = st;
        this.dirty = true;
        return true;
    }

    @Nonnull
    public GuiStyle getStyle() {
        return this.style;
    }

    public void setBuffXY(BuffStyle buffStyle, int x, int y) {
        this.buffStyle = buffStyle;
        this.buffX = x;
        this.buffY = y;
        this.dirty = true;
    }

    public BuffStyle getBuffStyle() {
        return this.buffStyle;
    }

    public int getBuffX() {
        return this.buffX;
    }

    public int getBuffY() {
        return this.buffY;
    }
}

