/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.base.GeneralConfig;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.network.IServerCommand;
import mcjty.lib.network.Networking;
import mcjty.lib.preferences.PreferencesProperties;
import mcjty.lib.setup.ClientSetup;
import mcjty.lib.setup.ModSetup;
import mcjty.lib.setup.Registration;
import mcjty.lib.typed.TypedMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod(value="mcjtylib")
public class McJtyLib {
    public static final String MODID = "mcjtylib";
    public static final ModSetup setup = new ModSetup();
    public static McJtyLib instance;
    private static final Map<Pair<String, String>, IServerCommand> serverCommands;
    private static final Map<Pair<String, String>, IServerCommand> clientCommands;
    private static final Map<String, CommandInfo> commandInfos;

    public McJtyLib(ModContainer container, IEventBus bus, Dist dist) {
        instance = this;
        Registration.init(bus);
        bus.addListener(setup::init);
        bus.addListener(Networking::registerMessages);
        bus.addListener(GeneralConfig::onLoad);
        bus.addListener(GeneralConfig::onFileChange);
        if (dist.isClient()) {
            bus.addListener(ClientSetup::init);
            bus.addListener(ClientSetup::registerKeyBinds);
            bus.addListener(ClientSetup::registerClientComponentTooltips);
        }
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)GeneralConfig.CLIENT_CONFIG);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)GeneralConfig.SERVER_CONFIG);
    }

    public static <T> void registerListCommandInfo(String command, Class<T> type, Function<FriendlyByteBuf, T> deserializer, BiConsumer<FriendlyByteBuf, T> serializer) {
        commandInfos.put(command, new CommandInfo<T>(type, deserializer, serializer));
    }

    public static CommandInfo getCommandInfo(String command) {
        return commandInfos.get(command);
    }

    public static void registerCommand(String modid, String id, IServerCommand command) {
        serverCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static void registerClientCommand(String modid, String id, IServerCommand command) {
        clientCommands.put((Pair<String, String>)Pair.of((Object)modid, (Object)id), command);
    }

    public static boolean handleCommand(String modid, String id, Player player, TypedMap arguments) {
        IServerCommand command = serverCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static boolean handleClientCommand(String modid, String id, Player player, TypedMap arguments) {
        IServerCommand command = clientCommands.get(Pair.of((Object)modid, (Object)id));
        if (command == null) {
            return false;
        }
        return command.execute(player, arguments);
    }

    public static PreferencesProperties getPreferencesProperties(Player player) {
        return (PreferencesProperties)player.getData(Registration.PREFERENCES_PROPERTIES);
    }

    static {
        serverCommands = new HashMap<Pair<String, String>, IServerCommand>();
        clientCommands = new HashMap<Pair<String, String>, IServerCommand>();
        commandInfos = new HashMap<String, CommandInfo>();
    }
}

