/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.me.items.CraftingTermScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.menu.AEBaseMenu;
import appeng.menu.me.items.CraftingTermMenu;
import de.mari_023.ae2wtlib.api.TextConstants;
import de.mari_023.ae2wtlib.api.gui.Icon;
import de.mari_023.ae2wtlib.api.gui.IconButton;
import de.mari_023.ae2wtlib.api.gui.ScrollingUpgradesPanel;
import de.mari_023.ae2wtlib.api.terminal.IUniversalTerminalCapable;
import de.mari_023.ae2wtlib.api.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wct.ArmorSlot;
import de.mari_023.ae2wtlib.wct.PlayerEntityWidget;
import de.mari_023.ae2wtlib.wct.WCTMenu;
import de.mari_023.ae2wtlib.wct.WirelessTerminalSettingsScreen;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetMode;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class WCTScreen
extends CraftingTermScreen<WCTMenu>
implements IUniversalTerminalCapable {
    private final IconButton magnetCardMenuButton;
    private final ScrollingUpgradesPanel upgradesPanel;

    public WCTScreen(WCTMenu container, Inventory playerInventory, Component title, ScreenStyle style) {
        super((CraftingTermMenu)container, playerInventory, title, style);
        if (((WCTMenu)this.getMenu()).isWUT()) {
            this.addToLeftToolbar((Button)this.cycleTerminalButton());
        }
        IconButton wirelessTerminalSettingsButton = new IconButton(btn -> this.switchToScreen((AEBaseScreen)new WirelessTerminalSettingsScreen(this)), Icon.MAGNET);
        this.widgets.add("wirelessTerminalSettingsButton", (AbstractWidget)wirelessTerminalSettingsButton);
        wirelessTerminalSettingsButton.setMessage(TextConstants.TERMINAL_SETTINGS);
        this.magnetCardMenuButton = new IconButton(btn -> ((WCTMenu)this.getMenu()).openMagnetMenu(), Icon.MAGNET_FILTER);
        this.widgets.add("magnetCardMenuButton", (AbstractWidget)this.magnetCardMenuButton);
        this.magnetCardMenuButton.setMessage(TextConstants.MAGNET_FILTER);
        IconButton trashButton = new IconButton(btn -> ((WCTMenu)this.getMenu()).openTrashMenu(), Icon.TRASH);
        this.widgets.add("trashButton", (AbstractWidget)trashButton);
        trashButton.setMessage((Component)TextConstants.TRASH);
        this.widgets.add("player", (AbstractWidget)new PlayerEntityWidget((LivingEntity)Objects.requireNonNull(Minecraft.getInstance().player)));
        this.upgradesPanel = this.addUpgradePanel(this.widgets, (AEBaseMenu)this.getMenu());
    }

    public void init() {
        super.init();
        this.upgradesPanel.setMaxRows(Math.max(2, this.getVisibleRows()));
    }

    private void setMagnetModeText() {
        this.magnetCardMenuButton.setVisibility(switch (((WCTMenu)this.getMenu()).getMagnetMode()) {
            default -> throw new MatchException(null, null);
            case MagnetMode.INVALID, MagnetMode.NO_CARD -> false;
            case MagnetMode.OFF, MagnetMode.PICKUP_ME, MagnetMode.PICKUP_INVENTORY, MagnetMode.PICKUP_ME_NO_MAGNET -> true;
        });
    }

    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.setMagnetModeText();
    }

    public boolean keyPressed(int keyCode, int scanCode, int keyPressed) {
        boolean value = super.keyPressed(keyCode, scanCode, keyPressed);
        if (!value) {
            return this.checkForTerminalKeys(keyCode, scanCode);
        }
        return true;
    }

    public WTMenuHost getHost() {
        return (WTMenuHost)((WCTMenu)this.getMenu()).getHost();
    }

    public void renderSlot(GuiGraphics guiGraphics, Slot s) {
        if (s instanceof ArmorSlot) {
            ArmorSlot armorSlot = (ArmorSlot)s;
            this.renderArmorSlot(guiGraphics, armorSlot);
        } else {
            super.renderSlot(guiGraphics, s);
        }
    }

    private void renderArmorSlot(GuiGraphics guiGraphics, ArmorSlot s) {
        ItemStack is = s.getItem();
        if (is.isEmpty() && s.isSlotEnabled()) {
            s.icon().getBlitter().dest(s.x, s.y).opacity(s.getOpacityOfIcon()).blit(guiGraphics);
        }
        super.renderSlot(guiGraphics, (Slot)s);
    }
}

