/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.rainshield.block;

import com.mojang.serialization.MapCodec;
import com.mrbysco.rainshield.util.RainShieldData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public class RainShieldBlock
extends RodBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<RainShieldBlock> CODEC = RainShieldBlock.simpleCodec(RainShieldBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<RainShieldBlock> codec() {
        return CODEC;
    }

    public RainShieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.animateTick(state, level, pos, random);
        if (level.isRaining() && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            for (double mod = 0.0; mod < 1.0; mod += 0.25) {
                for (double a = 0.0; a <= Math.PI * 2; a += 0.3141592653589793) {
                    double x = (double)pos.getX() + 0.5 + (1.0 - mod) * Math.cos(a);
                    double z = (double)pos.getZ() + 0.5 + (1.0 - mod) * Math.sin(a);
                    level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x, (double)((float)pos.getY() + 1.7f) + mod, z, 0.0, 0.02, 0.0);
                    level.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, (double)((float)pos.getY() + 1.6f) + mod, z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        RainShieldData.addRainShieldPos(pos, level);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            RainShieldData.removeRainShieldPos(pos, level);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.isClientSide && (flag = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        FluidState fluidstate = placeContext.getLevel().getFluidState(placeContext.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placeContext.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockStateBuilder) {
        blockStateBuilder.add(new Property[]{FACING, POWERED, WATERLOGGED});
    }
}

