/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.mixin;

import com.hollingsworth.arsnouveau.common.ritual.RitualAwakening;
import com.shynieke.georenouveau.entity.GeOreGolem;
import com.shynieke.georenouveau.entity.LinkedGeOre;
import com.shynieke.georenouveau.registry.CompatRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RitualAwakening.class})
public class RitualAwakeningMixin {
    @Shadow(remap=false)
    BlockPos foundPos;
    @Shadow(remap=false)
    EntityType<? extends LivingEntity> entity;
    @Unique
    private LinkedGeOre georenouveau_linkedGeOre;

    @Inject(method={"findTargets(Lnet/minecraft/world/level/Level;)V"}, locals=LocalCapture.NO_CAPTURE, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void georenouveau_findTargets(Level level, CallbackInfo ci) {
        RitualAwakening ritual = (RitualAwakening)this;
        this.georenouveau_linkedGeOre = LinkedGeOre.DEFAULT;
        for (BlockPos p : BlockPos.withinManhattan((BlockPos)ritual.getPos(), (int)3, (int)1, (int)3)) {
            List<LinkedGeOre> linkedGeOres = Arrays.stream(LinkedGeOre.values()).filter(geore -> level.getBlockState(p).is(geore.getBudding())).toList();
            if (linkedGeOres.isEmpty()) continue;
            LinkedGeOre linked = linkedGeOres.getFirst();
            if (!level.getBlockState(p).is(linked.getBudding())) continue;
            level.setBlock(p, Blocks.AIR.defaultBlockState(), 3);
            this.entity = CompatRegistry.GEORE_GOLEM.get();
            this.foundPos = p;
            this.georenouveau_linkedGeOre = linked;
            ci.cancel();
            break;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="INVOKE", target="Lcom/hollingsworth/arsnouveau/client/particle/ParticleUtil;spawnPoof(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;)V", shift=At.Shift.AFTER, ordinal=0)}, remap=false, cancellable=true)
    private void georenouveau_tick(CallbackInfo ci) {
        if (this.georenouveau_linkedGeOre != LinkedGeOre.DEFAULT) {
            RitualAwakening ritual = (RitualAwakening)this;
            Level level = ritual.getWorld();
            LivingEntity walker = (LivingEntity)this.entity.create(level);
            if (walker instanceof GeOreGolem) {
                GeOreGolem golem = (GeOreGolem)walker;
                golem.setLinkedGeOre(this.georenouveau_linkedGeOre);
                golem.setPos((double)this.foundPos.getX() + 0.5, this.foundPos.getY(), (double)this.foundPos.getZ() + 0.5);
                level.addFreshEntity((Entity)golem);
            }
            ritual.setFinished();
            ci.cancel();
        }
    }
}

