/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.georenouveau.entity;

import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.entity.AmethystGolem;
import com.hollingsworth.arsnouveau.common.entity.goal.GoBackHomeGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.amethyst_golem.DepositAmethystGoal;
import com.hollingsworth.arsnouveau.setup.registry.DataComponentRegistry;
import com.shynieke.georenouveau.GeOreNouveau;
import com.shynieke.georenouveau.entity.LinkedGeOre;
import com.shynieke.georenouveau.entity.goal.GeOreConvertBuddingGoal;
import com.shynieke.georenouveau.entity.goal.GeOreGrowClusterGoal;
import com.shynieke.georenouveau.entity.goal.GeOreHarvestClusterGoal;
import com.shynieke.georenouveau.entity.goal.GeOrePickupAmethystGoal;
import com.shynieke.georenouveau.registry.CompatRegistry;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.neoforge.common.CommonHooks;
import org.jetbrains.annotations.Nullable;

public class GeOreGolem
extends AmethystGolem {
    public static final EntityDataAccessor<LinkedGeOre> LINKED_GEORE = SynchedEntityData.defineId(GeOreGolem.class, CompatRegistry.LINKED_SERIALIZER.get());

    public GeOreGolem(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new GoBackHomeGoal((Mob)this, () -> ((GeOreGolem)this).getHome(), 10, () -> true));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new GeOreConvertBuddingGoal(this, () -> this.convertCooldown <= 0 && this.getHome() != null && this.getMainHandItem().isEmpty()));
        this.goalSelector.addGoal(4, (Goal)new GeOreGrowClusterGoal(this, () -> this.growCooldown <= 0 && this.getHome() != null && this.getMainHandItem().isEmpty()));
        this.goalSelector.addGoal(5, (Goal)new GeOreHarvestClusterGoal(this, () -> this.harvestCooldown <= 0 && this.getHome() != null && !this.isImbueing() && this.getMainHandItem().isEmpty()));
        this.goalSelector.addGoal(2, (Goal)new GeOrePickupAmethystGoal(this, () -> this.getHome() != null && this.pickupCooldown <= 0));
        this.goalSelector.addGoal(2, (Goal)new DepositAmethystGoal((AmethystGolem)this, () -> this.getHome() != null && !this.getMainHandItem().isEmpty()));
    }

    public void scanBlocks() {
        BlockPos pos = this.getHome().immutable();
        this.amethystBlocks = new ArrayList();
        this.buddingBlocks = new ArrayList();
        LinkedGeOre linked = this.getLinkedGeOre();
        for (BlockPos b : BlockPos.betweenClosed((BlockPos)pos.below(3).south(5).east(5), (BlockPos)pos.above(10).north(5).west(5))) {
            if (this.level().getBlockState(b).isAir()) continue;
            if (this.level().getBlockState(b).is(linked.getBlock())) {
                this.amethystBlocks.add(b.immutable());
            }
            if (!this.level().getBlockState(b).is(linked.getBudding())) continue;
            this.buddingBlocks.add(b.immutable());
        }
    }

    public void die(DamageSource source) {
        if (!this.level().isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)this.getLinkedGeOre().getCharm());
            stack.set((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
            if (this.getMainHandItem() != null) {
                this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getMainHandItem()));
            }
        }
        if (CommonHooks.onLivingDeath((LivingEntity)this, (DamageSource)source)) {
            return;
        }
        if (!this.isRemoved() && !this.dead) {
            Entity entity = source.getEntity();
            LivingEntity livingentity = this.getKillCredit();
            if (this.deathScore >= 0 && livingentity != null) {
                livingentity.awardKillScore((Entity)this, this.deathScore, source);
            }
            if (this.isSleeping()) {
                this.stopSleeping();
            }
            if (!this.level().isClientSide && this.hasCustomName()) {
                GeOreNouveau.LOGGER.info("Named entity {} died: {}", (Object)this, (Object)this.getCombatTracker().getDeathMessage().getString());
            }
            this.dead = true;
            this.getCombatTracker().recheckStatus();
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (entity == null || entity.killedEntity(serverLevel, (LivingEntity)this)) {
                    this.gameEvent((Holder)GameEvent.ENTITY_DIE);
                    this.dropAllDeathLoot(serverLevel, source);
                    this.createWitherRose(livingentity);
                }
                this.level().broadcastEntityEvent((Entity)this, (byte)3);
            }
            this.setPose(Pose.DYING);
        }
    }

    public boolean onDispel(@Nullable LivingEntity caster) {
        if (this.isRemoved()) {
            return false;
        }
        if (!this.level().isClientSide) {
            ItemStack stack = new ItemStack((ItemLike)this.getLinkedGeOre().getCharm());
            stack.set((Supplier)DataComponentRegistry.PERSISTENT_FAMILIAR_DATA, (Object)this.createCharmData());
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack.copy()));
            stack = this.getMainHandItem();
            this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), stack));
            ParticleUtil.spawnPoof((ServerLevel)((ServerLevel)this.level()), (BlockPos)this.blockPosition());
            this.remove(Entity.RemovalReason.DISCARDED);
        }
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LINKED_GEORE, (Object)LinkedGeOre.DEFAULT);
    }

    public void setLinkedGeOre(LinkedGeOre linked) {
        this.entityData.set(LINKED_GEORE, (Object)linked);
    }

    public LinkedGeOre getLinkedGeOre() {
        return (LinkedGeOre)((Object)this.entityData.get(LINKED_GEORE));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setLinkedGeOre(LinkedGeOre.values()[tag.getByte("LinkedGeOre")]);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("LinkedGeOre", (byte)this.getLinkedGeOre().ordinal());
    }
}

