/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.backupmanager.client.gui;

import com.google.common.collect.Streams;
import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import net.creeperhost.backupmanager.BackupManager;
import net.creeperhost.backupmanager.client.gui.BMStyle;
import net.creeperhost.backupmanager.client.gui.OptionDialog;
import net.creeperhost.backupmanager.client.gui.TextInputDialog;
import net.creeperhost.backupmanager.providers.Backup;
import net.creeperhost.backupmanager.providers.BackupException;
import net.creeperhost.backupmanager.providers.FTBBackupProvider;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.elements.GuiButton;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiList;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.elements.GuiSlider;
import net.creeperhost.polylib.client.modulargui.elements.GuiText;
import net.creeperhost.polylib.client.modulargui.elements.GuiTextList;
import net.creeperhost.polylib.client.modulargui.elements.GuiTexture;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Align;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Axis;
import net.creeperhost.polylib.client.modulargui.lib.geometry.ConstrainedGeometry;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Constraint;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoParam;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GeoRef;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.minecraft.CharPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class BackupsGui
implements GuiProvider {
    private static final SimpleDateFormat DATE_TIME_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
    private final SelectWorldScreen screen;
    private GuiList<Backup> backupList;
    private Backup selected = null;

    public BackupsGui(SelectWorldScreen screen) {
        this.screen = screen;
        BackupManager.refreshBackups();
    }

    public GuiElement<?> createRootElement(ModularGui gui) {
        return BMStyle.Flat.background(gui);
    }

    public void buildGui(ModularGui gui) {
        gui.renderScreenBackground(false);
        gui.initFullscreenGui();
        gui.setGuiTitle((Component)Component.translatable((String)"backupmanager:gui.backups.title"));
        GuiElement root = gui.getRoot();
        GuiText title = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)root, gui.getGuiTitle()).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)5.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.LEFT)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)root.get(GeoParam.RIGHT)));
        GuiElement listBackground = (GuiElement)((GuiRectangle)((GuiRectangle)((GuiRectangle)new GuiRectangle((GuiParent)root).fill(-2145378272).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.LEFT), (double)10.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.RIGHT), (double)-10.0))).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.TOP), (double)20.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)root.get(GeoParam.BOTTOM), (double)-24.0));
        GuiButton back = (GuiButton)((GuiButton)((GuiButton)((GuiButton)BMStyle.Flat.button(root, (Component)Component.translatable((String)"backupmanager:button.back_arrow")).onPress(() -> gui.mc().setScreen(gui.getParentScreen())).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)listBackground.get(GeoParam.TOP), (double)-4.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)listBackground.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)50.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)12.0));
        GuiButton restore = (GuiButton)((GuiButton)((GuiButton)((GuiButton)((GuiButton)BMStyle.Flat.buttonPrimary(root, (Component)Component.translatable((String)"backupmanager:button.restore_backup")).setTooltip(new Component[]{Component.translatable((String)"backupmanager:button.restore_backup.info")})).setDisabled(() -> this.selected == null).onPress(() -> this.restoreSelected(gui)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)listBackground.get(GeoParam.BOTTOM), (double)5.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.match((GeoRef)listBackground.get(GeoParam.LEFT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        GuiButton delete = (GuiButton)((GuiButton)((GuiButton)((GuiButton)BMStyle.Flat.buttonCaution(root, (Component)Component.translatable((String)"backupmanager:button.delete_backup")).onPress(() -> this.deleteSelected(gui)).setDisabled(() -> this.selected == null).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)listBackground.get(GeoParam.BOTTOM), (double)5.0))).constrain(GeoParam.RIGHT, (Constraint)Constraint.match((GeoRef)listBackground.get(GeoParam.RIGHT)))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)150.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)14.0));
        this.backupList = new GuiList((GuiParent)listBackground);
        this.backupList.setDisplayBuilder((x$0, x$1) -> new BackupElement(this, (GuiParent<?>)x$0, (Backup)x$1));
        Constraints.bind(this.backupList, (ConstrainedGeometry)listBackground, (double)2.0);
        Assembly<? extends GuiElement<?>, GuiSlider> scrollBar = BMStyle.Flat.scrollBar(root, Axis.Y);
        ((GuiElement)((GuiElement)((GuiElement)scrollBar.container.setEnabled(() -> this.backupList.hiddenSize() > 0.0).constrain(GeoParam.TOP, (Constraint)Constraint.match((GeoRef)listBackground.get(GeoParam.TOP)))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.match((GeoRef)listBackground.get(GeoParam.BOTTOM)))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)listBackground.get(GeoParam.RIGHT), (double)2.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)6.0));
        ((GuiSlider)scrollBar.primary).setScrollableElement(this.backupList).setSliderState(this.backupList.scrollState());
        this.updateList(false);
    }

    private void deleteSelected(ModularGui gui) {
        if (this.selected == null) {
            return;
        }
        try {
            this.selected.delete();
            this.selected = null;
            this.updateList(true);
        }
        catch (BackupException ex) {
            OptionDialog.simpleInfoDialog(gui, (Component)Component.translatable((String)"backupmanager:gui.backups.error_occurred", (Object[])new Object[]{ex.getComponent().copy().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.RED));
        }
    }

    private void restoreSelected(ModularGui gui) {
        if (this.selected == null) {
            return;
        }
        TextInputDialog dialog = new TextInputDialog((GuiParent<?>)gui.getRoot(), (Component)Component.translatable((String)"backupmanager:gui.backups.restore_name"));
        dialog.setResultCallback(name -> {
            try {
                this.selected.restore((String)name);
                this.screen.list.reloadWorldList();
                this.selected = null;
                OptionDialog.simpleInfoDialog(gui, (Component)Component.translatable((String)"backupmanager:gui.backups.restored").withStyle(ChatFormatting.GREEN));
            }
            catch (BackupException ex) {
                OptionDialog.simpleInfoDialog(gui, (Component)Component.translatable((String)"backupmanager:gui.backups.error_occurred", (Object[])new Object[]{ex.getComponent().copy().withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.RED));
            }
        });
    }

    private void updateList(boolean refresh) {
        if (refresh) {
            BackupManager.refreshBackups();
        }
        ArrayList<Backup> backups = new ArrayList<Backup>(BackupManager.getBackups().values());
        backups.sort(Comparator.comparingLong(Backup::creationTime).reversed());
        this.backupList.getList().clear();
        this.backupList.getList().addAll(backups);
        this.backupList.rebuildElements();
    }

    /*
     * Exception performing whole class analysis.
     */
    public class BackupElement
    extends GuiElement<BackupElement>
    implements BackgroundRender {
        private final Backup backup;
        final /* synthetic */ BackupsGui this$0;

        /*
         * Unable to fully structure code
         */
        public BackupElement(@NotNull BackupsGui this$0, GuiParent<?> parent, Backup backup) {
            this.this$0 = this$0;
            super(parent);
            this.backup = backup;
            this.constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)(24 + backup.infoText().size() * 9)));
            leftOffset = 3;
            if (!(backup instanceof FTBBackupProvider.FTBBackup)) ** GOTO lbl-1000
            b = (FTBBackupProvider.FTBBackup)backup;
            if (b.preview != null && !b.preview.isEmpty()) {
                if (b.getIcon() == null) {
                    b.setIcon(FaviconTexture.forWorld((TextureManager)this.mc().getTextureManager(), (String)Util.sanitizeName((String)b.sha1, (CharPredicate)(CharPredicate)LambdaMetafactory.metafactory(null, null, null, (C)Z, validPathChar(char ), (C)Z)())));
                    try {
                        encoded = b.preview.replace("data:image/png;base64, ", "");
                        image = ImageIO.read(new ByteArrayInputStream(Base64.getDecoder().decode(encoded)));
                        scaled = new BufferedImage(64, 64, 2);
                        scaled.createGraphics().drawImage(image, 0, 0, scaled.getWidth(), scaled.getHeight(), 0, 0, image.getWidth(), image.getWidth(), null);
                        bos = new ByteArrayOutputStream();
                        ImageIO.write((RenderedImage)scaled, "png", bos);
                        b.getIcon().upload(NativeImage.read((byte[])bos.toByteArray()));
                    }
                    catch (Throwable e) {
                        BackupManager.LOGGER.error("Failed to load backup preview", e);
                    }
                }
            } else lbl-1000:
            // 2 sources

            {
                zip = new File(backup.backupLocation());
                if (backup.getIcon() == null && zip.exists() && zip.getName().endsWith(".zip")) {
                    backup.setIcon(FaviconTexture.forWorld((TextureManager)this.mc().getTextureManager(), (String)Util.sanitizeName((String)backup.backupLocation(), (CharPredicate)(CharPredicate)LambdaMetafactory.metafactory(null, null, null, (C)Z, validPathChar(char ), (C)Z)())));
                    try {
                        fs = FileSystems.newFileSystem(zip.toPath());
                        try {
                            paths = Streams.stream(fs.getRootDirectories()).filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$0(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).toList();
                            worldDir = null;
                            i = 0;
                            while (paths.size() == 1 && i++ < 10) {
                                worldDir = paths.get(0);
                                paths = Files.list(worldDir).filter((Predicate<Path>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$new$1(java.nio.file.Path ), (Ljava/nio/file/Path;)Z)()).toList();
                            }
                            if (worldDir != null && i < 10 && Files.exists(icon = worldDir.resolve("icon.png"), new LinkOption[0])) {
                                backup.getIcon().upload(NativeImage.read((InputStream)Files.newInputStream(icon, new OpenOption[0])));
                            }
                        }
                        finally {
                            if (fs != null) {
                                fs.close();
                            }
                        }
                    }
                    catch (Throwable e) {
                        BackupManager.LOGGER.error("Failed to load backup preview", e);
                    }
                }
            }
            if (backup.getIcon() != null) {
                leftOffset = (int)this.ySize() - 2;
                icon = (GuiTexture)((GuiTexture)((GuiTexture)((GuiTexture)new GuiTexture((GuiParent)this, (Supplier<Material>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$new$2(net.creeperhost.backupmanager.providers.Backup ), ()Lnet/creeperhost/polylib/client/modulargui/sprite/Material;)((Backup)backup)).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)1.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)1.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)leftOffset))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)leftOffset));
                leftOffset += 3;
            }
            name = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.literal((String)(backup.name() + (String)(backup.displayName().isEmpty() != false ? "" : " (" + backup.displayName() + ")")))).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)leftOffset))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
            created = (GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)Component.translatable((String)"backupmanager:gui.backups.created", (Object[])new Object[]{BackupsGui.DATE_TIME_FORMAT.format(backup.creationTime())}).withStyle(ChatFormatting.GRAY)).setShadow(false).setAlignment(Align.LEFT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)name.get(GeoParam.BOTTOM), (double)2.0))).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)leftOffset))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
            provText = Component.literal((String)backup.backupProvider());
            provider = (GuiText)((GuiText)((GuiText)((GuiText)((GuiText)new GuiText((GuiParent)this, (Component)provText).setTooltip(new Component[]{Component.translatable((String)"backupmanager:gui.backups.provider", (Object[])new Object[]{backup.backupProvider()})})).setShadow(false).setAlignment(Align.RIGHT).constrain(GeoParam.TOP, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.TOP), (double)3.0))).constrain(GeoParam.WIDTH, (Constraint)Constraint.literal((double)this.font().width((FormattedText)provText)))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.HEIGHT, (Constraint)Constraint.literal((double)8.0));
            if (!backup.infoText().isEmpty()) {
                var9_12 = ((GuiTextList)((GuiTextList)((GuiTextList)new GuiTextList((GuiParent)this, backup.infoText()).setHorizontalAlign(Align.MIN).constrain(GeoParam.LEFT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.LEFT), (double)leftOffset))).constrain(GeoParam.RIGHT, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.RIGHT), (double)-2.0))).constrain(GeoParam.BOTTOM, (Constraint)Constraint.relative((GeoRef)this.get(GeoParam.BOTTOM), (double)-2.0))).autoHeight();
            }
            this.setTooltip(backup.hoverText());
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.isMouseOver()) {
                this.this$0.selected = this.backup;
            }
            return super.mouseClicked(mouseX, mouseY, button);
        }

        public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
            boolean isSelected = this.this$0.selected == this.backup;
            render.borderRect(this.getRectangle(), 1.0, this.isMouseOver() || isSelected ? 0x10FFFFFF : 0, BMStyle.Flat.listEntryBorder(isSelected));
        }

        private static /* synthetic */ Material lambda$new$2(Backup backup) {
            return Material.fromRawTexture((ResourceLocation)backup.getIcon().textureLocation());
        }

        private static /* synthetic */ boolean lambda$new$1(Path x$0) {
            return Files.isDirectory(x$0, new LinkOption[0]);
        }

        private static /* synthetic */ boolean lambda$new$0(Path x$0) {
            return Files.isDirectory(x$0, new LinkOption[0]);
        }
    }
}

