/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.experience.source.ExperienceSource;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.calculation.LegacyBuiltinPrototypes;
import net.puffish.skillsmod.calculation.operation.builtin.AttributeOperation;
import net.puffish.skillsmod.calculation.operation.builtin.BlockCondition;
import net.puffish.skillsmod.calculation.operation.builtin.BlockStateCondition;
import net.puffish.skillsmod.calculation.operation.builtin.DamageTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.EffectOperation;
import net.puffish.skillsmod.calculation.operation.builtin.EntityTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.ItemCondition;
import net.puffish.skillsmod.calculation.operation.builtin.ItemStackCondition;
import net.puffish.skillsmod.calculation.operation.builtin.ScoreboardOperation;
import net.puffish.skillsmod.calculation.operation.builtin.StatCondition;
import net.puffish.skillsmod.calculation.operation.builtin.StatTypeCondition;
import net.puffish.skillsmod.calculation.operation.builtin.SwitchOperation;
import net.puffish.skillsmod.calculation.operation.builtin.TagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyBlockTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyDamageTypeTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyEntityTypeTagCondition;
import net.puffish.skillsmod.calculation.operation.builtin.legacy.LegacyItemTagCondition;
import net.puffish.skillsmod.commands.CategoryCommand;
import net.puffish.skillsmod.commands.ExperienceCommand;
import net.puffish.skillsmod.commands.OpenCommand;
import net.puffish.skillsmod.commands.PointsCommand;
import net.puffish.skillsmod.commands.SkillsCommand;
import net.puffish.skillsmod.config.CategoryConfig;
import net.puffish.skillsmod.config.Config;
import net.puffish.skillsmod.config.ModConfig;
import net.puffish.skillsmod.config.PackConfig;
import net.puffish.skillsmod.config.experience.ExperienceSourceConfig;
import net.puffish.skillsmod.config.reader.ConfigReader;
import net.puffish.skillsmod.config.reader.FileConfigReader;
import net.puffish.skillsmod.config.reader.PackConfigReader;
import net.puffish.skillsmod.config.skill.SkillConfig;
import net.puffish.skillsmod.config.skill.SkillDefinitionConfig;
import net.puffish.skillsmod.config.skill.SkillRewardConfig;
import net.puffish.skillsmod.experience.source.builtin.CraftItemExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.DealDamageExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.EatFoodExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.FishItemExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.HealExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.IncreaseStatExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.KillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.MineBlockExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.SharedKillEntityExperienceSource;
import net.puffish.skillsmod.experience.source.builtin.TakeDamageExperienceSource;
import net.puffish.skillsmod.impl.config.ConfigContextImpl;
import net.puffish.skillsmod.impl.rewards.RewardUpdateContextImpl;
import net.puffish.skillsmod.network.Packets;
import net.puffish.skillsmod.reward.builtin.AttributeReward;
import net.puffish.skillsmod.reward.builtin.CommandReward;
import net.puffish.skillsmod.reward.builtin.ScoreboardReward;
import net.puffish.skillsmod.reward.builtin.TagReward;
import net.puffish.skillsmod.server.data.CategoryData;
import net.puffish.skillsmod.server.data.PlayerData;
import net.puffish.skillsmod.server.data.ServerData;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.network.packets.in.SkillClickInPacket;
import net.puffish.skillsmod.server.network.packets.out.ExperienceUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.HideCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.OpenScreenOutPacket;
import net.puffish.skillsmod.server.network.packets.out.PointsUpdateOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowCategoryOutPacket;
import net.puffish.skillsmod.server.network.packets.out.ShowToastOutPacket;
import net.puffish.skillsmod.server.network.packets.out.SkillUpdateOutPacket;
import net.puffish.skillsmod.server.setup.ServerRegistrar;
import net.puffish.skillsmod.server.setup.SkillsArgumentTypes;
import net.puffish.skillsmod.server.setup.SkillsGameRules;
import net.puffish.skillsmod.util.ChangeListener;
import net.puffish.skillsmod.util.DisposeContext;
import net.puffish.skillsmod.util.PathUtils;
import net.puffish.skillsmod.util.PrefixedLogger;
import net.puffish.skillsmod.util.ToastType;
import net.puffish.skillsmod.util.VersionedConfigContext;

public class SkillsMod {
    public static final int MIN_CONFIG_VERSION = 1;
    public static final int MAX_CONFIG_VERSION = 3;
    private static SkillsMod instance;
    private final PrefixedLogger logger = new PrefixedLogger("puffish_skills");
    private final Path modConfigDir;
    private final ServerPacketSender packetSender;
    private final ChangeListener<Optional<Map<ResourceLocation, CategoryConfig>>> categories = new ChangeListener(Optional.empty(), () -> {});

    private SkillsMod(Path modConfigDir, ServerPacketSender packetSender) {
        this.modConfigDir = modConfigDir;
        this.packetSender = packetSender;
    }

    public static SkillsMod getInstance() {
        return instance;
    }

    public static void setup(Path configDir, ServerRegistrar registrar, ServerEventReceiver eventReceiver, ServerPacketSender packetSender) {
        Path modConfigDir = configDir.resolve("puffish_skills");
        try {
            Files.createDirectories(modConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        instance = new SkillsMod(modConfigDir, packetSender);
        registrar.registerInPacket(Packets.SKILL_CLICK, SkillClickInPacket::read, instance::onSkillClickPacket);
        registrar.registerOutPacket(Packets.SHOW_CATEGORY);
        registrar.registerOutPacket(Packets.HIDE_CATEGORY);
        registrar.registerOutPacket(Packets.SKILL_UPDATE);
        registrar.registerOutPacket(Packets.POINTS_UPDATE);
        registrar.registerOutPacket(Packets.EXPERIENCE_UPDATE);
        registrar.registerOutPacket(Packets.SHOW_TOAST);
        registrar.registerOutPacket(Packets.OPEN_SCREEN);
        eventReceiver.registerListener(instance.new EventListener());
        SkillsGameRules.register(registrar);
        SkillsArgumentTypes.register(registrar);
        AttributeReward.register();
        CommandReward.register();
        ScoreboardReward.register();
        TagReward.register();
        LegacyBlockTagCondition.register();
        LegacyDamageTypeTagCondition.register();
        LegacyEntityTypeTagCondition.register();
        LegacyItemTagCondition.register();
        AttributeOperation.register();
        BlockCondition.register();
        BlockStateCondition.register();
        DamageTypeCondition.register();
        EffectOperation.register();
        EntityTypeCondition.register();
        ItemCondition.register();
        ItemStackCondition.register();
        ScoreboardOperation.register();
        StatCondition.register();
        StatTypeCondition.register();
        SwitchOperation.register();
        TagCondition.register();
        CraftItemExperienceSource.register();
        DealDamageExperienceSource.register();
        EatFoodExperienceSource.register();
        FishItemExperienceSource.register();
        HealExperienceSource.register();
        IncreaseStatExperienceSource.register();
        KillEntityExperienceSource.register();
        MineBlockExperienceSource.register();
        SharedKillEntityExperienceSource.register();
        TakeDamageExperienceSource.register();
        LegacyBuiltinPrototypes.register();
    }

    public static ResourceLocation createIdentifier(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"puffish_skills", (String)path);
    }

    public static ResourceLocation convertIdentifier(ResourceLocation id) {
        if (id.getNamespace().equals("minecraft")) {
            return SkillsMod.createIdentifier(id.getPath());
        }
        return id;
    }

    public static MutableComponent createTranslatable(String type, String path, Object ... args) {
        return Component.translatableEscape((String)Util.makeDescriptionId((String)type, (ResourceLocation)SkillsMod.createIdentifier(path)), (Object[])args);
    }

    public PrefixedLogger getLogger() {
        return this.logger;
    }

    private void copyConfigFromJar() {
        PathUtils.copyFileFromJar(Path.of("config", "config.json"), this.modConfigDir.resolve("config.json"));
    }

    private void loadModConfig(MinecraftServer server) {
        if (!Files.exists(this.modConfigDir, new LinkOption[0]) || PathUtils.isDirectoryEmpty(this.modConfigDir)) {
            this.copyConfigFromJar();
        }
        FileConfigReader reader = new FileConfigReader(this.modConfigDir);
        ConfigContextImpl context = new ConfigContextImpl(server);
        reader.read(Path.of("config.json", new String[0])).andThen(rootElement -> ModConfig.parse(rootElement, (ConfigContext)context)).andThen(modConfig -> this.loadCategories(reader, (Config)modConfig, "puffish_skills", context).ifSuccess(map -> {
            LinkedHashMap<ResourceLocation, CategoryConfig> cumulatedMap = new LinkedHashMap<ResourceLocation, CategoryConfig>((Map<ResourceLocation, CategoryConfig>)map);
            this.showSuccess("Mod configuration", modConfig.getShowWarnings(), context);
            if (this.loadPackConfig(server, cumulatedMap, modConfig.getShowWarnings())) {
                this.categories.set(Optional.of(cumulatedMap), () -> {
                    for (CategoryConfig category : cumulatedMap.values()) {
                        category.dispose(new DisposeContext(server));
                    }
                });
            } else {
                this.categories.set(Optional.empty(), () -> {});
            }
        })).ifFailure(problem -> {
            this.categories.set(Optional.empty(), () -> {});
            this.showFailure("Mod configuration", (Problem)problem);
        });
    }

    private Result<Map<ResourceLocation, CategoryConfig>, Problem> loadCategories(ConfigReader reader, Config config, String namespace, ConfigContext context) {
        VersionedConfigContext versionedContext = new VersionedConfigContext(context, config.getVersion());
        return reader.readCategories(namespace, config.getCategories(), versionedContext);
    }

    private boolean loadPackConfig(MinecraftServer server, Map<ResourceLocation, CategoryConfig> cumulatedMap, boolean showWarning) {
        ResourceManager resourceManager = server.getResourceManager();
        Map resources = resourceManager.listResources("puffish_skills", id -> id.getPath().endsWith("config.json"));
        boolean allSuccess = true;
        for (Map.Entry entry : resources.entrySet()) {
            Resource resource = (Resource)entry.getValue();
            ResourceLocation id2 = (ResourceLocation)entry.getKey();
            String namespace = id2.getNamespace();
            PackConfigReader reader = new PackConfigReader(resourceManager, namespace);
            ConfigContextImpl context = new ConfigContextImpl(server);
            if (!reader.readResource(id2, resource).andThen(rootElement -> PackConfig.parse(namespace, rootElement, (ConfigContext)context)).andThen(packConfig -> this.loadCategories(reader, (Config)packConfig, namespace, context)).andThen(map -> {
                ArrayList<Problem> problems = new ArrayList<Problem>();
                for (ResourceLocation key : map.keySet()) {
                    if (!cumulatedMap.containsKey(key)) continue;
                    problems.add(Problem.message("Category `" + String.valueOf(key) + "` already exists."));
                }
                if (problems.isEmpty()) {
                    return Result.success(map);
                }
                return Result.failure(Problem.combine(problems));
            }).ifFailure(problem -> this.showFailure("Data pack `" + namespace + "`", (Problem)problem)).ifSuccess(map -> {
                cumulatedMap.putAll((Map<ResourceLocation, CategoryConfig>)map);
                this.showSuccess("Data pack `" + namespace + "`", showWarning, context);
            }).getSuccess().isEmpty()) continue;
            allSuccess = false;
        }
        return allSuccess;
    }

    private void showSuccess(String name, boolean showWarnings, ConfigContextImpl context) {
        if (showWarnings && !context.warnings().isEmpty()) {
            this.logger.warn(name + " loaded successfully with warning(s):" + System.lineSeparator() + context.warnings().stream().collect(Collectors.joining(System.lineSeparator())));
        } else {
            this.logger.info(name + " loaded successfully!");
        }
    }

    private void showFailure(String name, Problem problem) {
        this.logger.error(name + " could not be loaded:" + System.lineSeparator() + String.valueOf(problem));
    }

    private void onSkillClickPacket(ServerPlayer player, SkillClickInPacket packet) {
        if (player.isSpectator()) {
            return;
        }
        this.tryUnlockSkill(player, packet.getCategoryId(), packet.getSkillId(), false);
    }

    public void unlockSkill(ServerPlayer player, ResourceLocation categoryId, String skillId) {
        this.tryUnlockSkill(player, categoryId, skillId, true);
    }

    private void tryUnlockSkill(ServerPlayer player, ResourceLocation categoryId, String skillId, boolean force) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            if (categoryData.tryUnlockSkill((CategoryConfig)category, player, skillId, force)) {
                this.packetSender.send(player, new SkillUpdateOutPacket(categoryId, skillId, true));
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            }
        }));
    }

    public void lockSkill(ServerPlayer player, ResourceLocation categoryId, String skillId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.lockSkill(skillId);
            this.packetSender.send(player, new SkillUpdateOutPacket(categoryId, skillId, false));
            this.applyRewards(player, (CategoryConfig)category, (CategoryData)categoryData);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void resetSkills(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.resetSkills();
            this.applyRewards(player, (CategoryConfig)category, (CategoryData)categoryData);
            this.syncCategory(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void eraseCategory(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.removeCategoryData((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void unlockCategory(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.unlockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public void lockCategory(ServerPlayer player, ResourceLocation categoryId) {
        this.getCategory(categoryId).ifPresent(category -> {
            PlayerData playerData = this.getPlayerData(player);
            playerData.lockCategory((CategoryConfig)category);
            this.syncCategory(player, (CategoryConfig)category);
        });
    }

    public Optional<Boolean> hasExperience(ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> category.getExperience().isPresent());
    }

    public void addExperience(ServerPlayer player, ResourceLocation categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.addExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public void setExperience(ServerPlayer player, ResourceLocation categoryId, int amount) {
        this.getCategory(categoryId).ifPresent(category -> {
            if (category.getExperience().isEmpty()) {
                return;
            }
            this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
                categoryData.setEarnedExperience(amount);
                this.syncExperience(player, (CategoryConfig)category, (CategoryData)categoryData);
                this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
            });
        });
    }

    public Optional<Integer> getExperience(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).flatMap(category -> {
            if (category.getExperience().isEmpty()) {
                return Optional.empty();
            }
            return this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getEarnedExperience);
        });
    }

    public void addExtraPoints(ServerPlayer player, ResourceLocation categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.addExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public void setExtraPoints(ServerPlayer player, ResourceLocation categoryId, int count) {
        this.getCategory(categoryId).ifPresent(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).ifPresent(categoryData -> {
            categoryData.setExtraPoints(count);
            this.syncPoints(player, (CategoryConfig)category, (CategoryData)categoryData);
        }));
    }

    public Optional<Integer> getExtraPoints(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).flatMap(category -> this.getCategoryDataIfUnlocked(player, (CategoryConfig)category).map(CategoryData::getExtraPoints));
    }

    public Optional<Integer> getPointsLeft(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getPointsLeft((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentLevel(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentLevel((CategoryConfig)category);
        });
    }

    public Optional<Integer> getCurrentExperience(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getCurrentExperience((CategoryConfig)category);
        });
    }

    public Optional<Integer> getRequiredExperience(ServerPlayer player, ResourceLocation categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredExperience((CategoryConfig)category, level);
        });
    }

    public Optional<Integer> getRequiredTotalExperience(ServerPlayer player, ResourceLocation categoryId, int level) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getRequiredTotalExperience((CategoryConfig)category, level);
        });
    }

    public Optional<Skill.State> getSkillState(ServerPlayer player, ResourceLocation categoryId, String skillId) {
        return this.getCategory(categoryId).flatMap(category -> category.getSkills().getById(skillId).flatMap(skill -> category.getDefinitions().getById(skill.getDefinitionId()).map(definition -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getSkillState((CategoryConfig)category, (SkillConfig)skill, (SkillDefinitionConfig)definition);
        })));
    }

    public Collection<ResourceLocation> getUnlockedCategories(ServerPlayer player) {
        PlayerData playerData = this.getPlayerData(player);
        return this.getAllCategories().stream().filter(playerData::isCategoryUnlocked).map(CategoryConfig::getId).toList();
    }

    public Collection<ResourceLocation> getCategories(boolean onlyWithExperience) {
        return this.getAllCategories().stream().filter(category -> !onlyWithExperience || category.getExperience().isPresent()).map(CategoryConfig::getId).toList();
    }

    public Optional<Collection<String>> getUnlockedSkills(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> {
            CategoryData categoryData = this.getPlayerData(player).getCategoryData((CategoryConfig)category);
            return categoryData.getUnlockedSkillIds();
        });
    }

    public Optional<Collection<String>> getSkills(ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getAll().stream().map(SkillConfig::getId).toList());
    }

    public boolean hasCategory(ResourceLocation categoryId) {
        return this.getCategory(categoryId).isPresent();
    }

    public boolean hasSkill(ResourceLocation categoryId, String skillId) {
        return this.getCategory(categoryId).map(category -> category.getSkills().getById(skillId).isPresent()).orElse(false);
    }

    private void showCategory(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new ShowCategoryOutPacket(category, categoryData));
    }

    private void hideCategory(ServerPlayer player, CategoryConfig category) {
        this.packetSender.send(player, new HideCategoryOutPacket(category.getId()));
    }

    private void syncPoints(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.packetSender.send(player, new PointsUpdateOutPacket(category.getId(), categoryData.getSpentPoints(category), categoryData.getEarnedPoints(category), player.level().getGameRules().getBoolean(SkillsGameRules.ANNOUNCE_NEW_POINTS)));
    }

    private void syncExperience(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        int level = categoryData.getCurrentLevel(category);
        this.packetSender.send(player, new ExperienceUpdateOutPacket(category.getId(), level, categoryData.getCurrentExperience(category), categoryData.getRequiredExperience(category, level)));
    }

    public void refreshReward(ServerPlayer player, Predicate<SkillRewardConfig> reward) {
        for (CategoryConfig category : this.getAllCategories()) {
            this.getCategoryDataIfUnlocked(player, category).ifPresent(categoryData -> categoryData.refreshReward(category, player, reward));
        }
    }

    public void visitExperienceSources(ServerPlayer player, Function<ExperienceSource, Integer> function) {
        for (CategoryConfig category : this.getAllCategories()) {
            category.getExperience().ifPresent(experience -> this.getCategoryDataIfUnlocked(player, category).ifPresent(categoryData -> {
                int amount = 0;
                for (ExperienceSourceConfig experienceSource : experience.getExperienceSources()) {
                    amount += ((Integer)function.apply(experienceSource.getInstance())).intValue();
                }
                if (amount != 0) {
                    categoryData.addExperience(amount);
                    this.syncExperience(player, category, (CategoryData)categoryData);
                    this.syncPoints(player, category, (CategoryData)categoryData);
                }
            }));
        }
    }

    private void applyRewards(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        categoryData.applyRewards(category, player);
    }

    private void resetRewards(ServerPlayer player, CategoryConfig category) {
        for (SkillDefinitionConfig definition : category.getDefinitions().getAll()) {
            for (SkillRewardConfig reward : definition.getRewards()) {
                reward.getInstance().update(new RewardUpdateContextImpl(player, 0, false));
            }
        }
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(ServerPlayer player, CategoryConfig category) {
        return this.getCategoryDataIfUnlocked(this.getPlayerData(player), category);
    }

    private Optional<CategoryData> getCategoryDataIfUnlocked(PlayerData playerData, CategoryConfig category) {
        if (playerData.isCategoryUnlocked(category)) {
            return Optional.of(playerData.getCategoryData(category));
        }
        return Optional.empty();
    }

    public Optional<Boolean> isCategoryUnlocked(ServerPlayer player, ResourceLocation categoryId) {
        return this.getCategory(categoryId).map(category -> this.getPlayerData(player).isCategoryUnlocked((CategoryConfig)category));
    }

    private Optional<CategoryConfig> getCategory(ResourceLocation categoryId) {
        return this.categories.get().flatMap(map -> Optional.ofNullable((CategoryConfig)map.get(categoryId)));
    }

    private Collection<CategoryConfig> getAllCategories() {
        return this.categories.get().map(Map::values).orElseGet(Collections::emptyList);
    }

    private void syncCategory(ServerPlayer player, CategoryConfig category, CategoryData categoryData) {
        this.applyRewards(player, category, categoryData);
        this.showCategory(player, category, categoryData);
    }

    private void syncCategory(ServerPlayer player, CategoryConfig category) {
        this.getCategoryDataIfUnlocked(player, category).ifPresentOrElse(categoryData -> this.syncCategory(player, category, (CategoryData)categoryData), () -> {
            this.resetRewards(player, category);
            this.hideCategory(player, category);
        });
    }

    public void syncAllCategories(ServerPlayer player) {
        if (this.isConfigValid()) {
            Collection<CategoryConfig> categories = this.getAllCategories();
            if (categories.isEmpty()) {
                this.showToast(player, ToastType.MISSING_CONFIG);
            } else {
                for (CategoryConfig category : categories) {
                    this.syncCategory(player, category);
                }
            }
        } else {
            this.showToast(player, ToastType.INVALID_CONFIG);
        }
    }

    private void showToast(ServerPlayer player, ToastType type) {
        if (this.isOperatorOrHost(player)) {
            this.packetSender.send(player, new ShowToastOutPacket(type));
        }
    }

    public void openScreen(ServerPlayer player, Optional<ResourceLocation> categoryId) {
        this.packetSender.send(player, new OpenScreenOutPacket(categoryId));
    }

    private boolean isConfigValid() {
        return this.categories.get().isPresent();
    }

    private PlayerData getPlayerData(ServerPlayer player) {
        return ServerData.getOrCreate(this.getPlayerServer(player)).getPlayerData(player);
    }

    private MinecraftServer getPlayerServer(ServerPlayer player) {
        return Objects.requireNonNull(player.getServer());
    }

    private boolean isOperatorOrHost(ServerPlayer player) {
        MinecraftServer server = this.getPlayerServer(player);
        return server.isSingleplayerOwner(player.getGameProfile()) || server.getPlayerList().isOp(player.getGameProfile());
    }

    private class EventListener
    implements ServerEventListener {
        private EventListener() {
        }

        @Override
        public void onServerStarting(MinecraftServer server) {
            SkillsMod.this.loadModConfig(server);
        }

        @Override
        public void onServerReload(MinecraftServer server) {
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                for (CategoryConfig category : SkillsMod.this.getAllCategories()) {
                    SkillsMod.this.hideCategory(player, category);
                }
            }
            SkillsMod.this.loadModConfig(server);
            for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                SkillsMod.this.syncAllCategories(player);
            }
        }

        @Override
        public void onPlayerJoin(ServerPlayer player) {
            SkillsMod.this.syncAllCategories(player);
        }

        @Override
        public void onCommandsRegister(CommandDispatcher<CommandSourceStack> dispatcher) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"puffish_skills").then(CategoryCommand.create())).then(SkillsCommand.create())).then(PointsCommand.create())).then(ExperienceCommand.create())).then(OpenCommand.create()));
        }
    }
}

