/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.trashcans.packet;

import com.supermartijn642.core.network.BlockEntityBasePacket;
import com.supermartijn642.core.network.PacketContext;
import com.supermartijn642.trashcans.TrashCanBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public class PacketChangeEnergyLimit
extends BlockEntityBasePacket<TrashCanBlockEntity> {
    private int amount;

    public PacketChangeEnergyLimit(BlockPos pos, int amount) {
        super(pos);
        this.amount = amount;
    }

    public PacketChangeEnergyLimit() {
    }

    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.writeInt(this.amount);
    }

    public void read(FriendlyByteBuf buffer) {
        super.read(buffer);
        this.amount = buffer.readInt();
    }

    public boolean verify(PacketContext context) {
        return Math.abs(this.amount) >= 1 && Math.abs(this.amount) <= 1000;
    }

    protected void handle(TrashCanBlockEntity entity, PacketContext context) {
        int amount;
        int limit;
        if (entity.energy && Math.abs(this.amount) >= 1 && Math.abs(this.amount) <= 10000 && entity.energyLimit != (limit = Math.min(Math.max(amount = entity.energyLimit == 1 && this.amount > 1 ? this.amount : entity.energyLimit + this.amount, 1), 10000000))) {
            entity.energyLimit = limit;
            entity.dataChanged();
        }
    }
}

