/*
 * Decompiled with CFR 0.152.
 */
package com.diontryban.ash_api.client.input;

import com.diontryban.ash_api.client.input.KeyMappingRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class KeyMappingRegistryNeoForge
extends KeyMappingRegistry {
    private static final Map<String, List<KeyMapping>> MOD_KEY_MAPPINGS = new HashMap<String, List<KeyMapping>>();

    @Override
    @NotNull
    protected KeyMapping registerImpl(@NotNull String modId, @NotNull KeyMapping keyMapping) {
        if (!MOD_KEY_MAPPINGS.containsKey(modId)) {
            MOD_KEY_MAPPINGS.put(modId, new ArrayList());
            IEventBus eventBus = ((ModContainer)ModList.get().getModContainerById(modId).orElseThrow(() -> new NullPointerException("Mod with id " + modId + " does not exist. Cannot register key mapping."))).getEventBus();
            if (eventBus != null) {
                eventBus.addListener(event -> {
                    for (KeyMapping key : MOD_KEY_MAPPINGS.get(modId)) {
                        event.register(key);
                    }
                });
            }
        }
        MOD_KEY_MAPPINGS.get(modId).add(keyMapping);
        return keyMapping;
    }
}

